<?php
/* Smarty version 4.3.1, created on 2023-11-05 06:57:58
  from '/Users/nikolaimv/Sites/vertu.loc/admin/templates/views/documents/collection.tpl' */

/* @var Smarty_Internal_Template $_smarty_tpl */
if ($_smarty_tpl->_decodeProperties($_smarty_tpl, array (
  'version' => '4.3.1',
  'unifunc' => 'content_65473cf60a1af4_10379732',
  'has_nocache_code' => false,
  'file_dependency' => 
  array (
    '50180026e694809e7752d66bac1ad62b1df12d12' => 
    array (
      0 => '/Users/nikolaimv/Sites/vertu.loc/admin/templates/views/documents/collection.tpl',
      1 => 1679630384,
      2 => 'file',
    ),
  ),
  'includes' => 
  array (
    'file:components/page-header.tpl' => 1,
  ),
),false)) {
function content_65473cf60a1af4_10379732 (Smarty_Internal_Template $_smarty_tpl) {
?><!-- Inner content -->
<div class="content-inner" data-bs-spy="scroll" data-bs-target="#page_nav">

	<!-- Page header -->
    <?php $_smarty_tpl->smarty->ext->_capture->open($_smarty_tpl, "buttons", null, null);
$_smarty_tpl->smarty->ext->_capture->close($_smarty_tpl);?>

    <?php $_smarty_tpl->smarty->ext->_capture->open($_smarty_tpl, "breadcrumb", null, null);?>
		<span class="breadcrumb-item active"><?php echo htmlspecialchars((string)$_smarty_tpl->tpl_vars['title']->value, ENT_QUOTES, 'UTF-8', true);?>
</span>
    <?php $_smarty_tpl->smarty->ext->_capture->close($_smarty_tpl);?>

    <?php $_smarty_tpl->smarty->ext->_capture->open($_smarty_tpl, "showBy", null, null);
$_smarty_tpl->smarty->ext->_capture->close($_smarty_tpl);?>

    <?php $_smarty_tpl->_subTemplateRender("file:components/page-header.tpl", $_smarty_tpl->cache_id, $_smarty_tpl->compile_id, 0, $_smarty_tpl->cache_lifetime, array('buttons'=>$_smarty_tpl->smarty->ext->_capture->getBuffer($_smarty_tpl, 'buttons'),'breadcrumb'=>$_smarty_tpl->smarty->ext->_capture->getBuffer($_smarty_tpl, 'breadcrumb'),'showBy'=>$_smarty_tpl->smarty->ext->_capture->getBuffer($_smarty_tpl, 'showBy')), 0, false);
?>
	<!-- /page header -->
	<!-- Content area -->
	<div class="content">

		<!-- Inner container -->
		<div class="d-flex align-items-stretch align-items-lg-start flex-column flex-lg-row">

			<!-- Left content -->
			<div class="flex-1 order-2 order-lg-1">

				<!-- Scrollspy -->
				<div class="card">
					<div class="card-header"><h5 class="mb-0">Коллекция</h5></div>

					<div class="card-body">

						<!-- How it works -->
						<div class="mb-4">
							<h6 class="fw-semibold" id="introduction">Введение</h6>
							<p>Класс <kbd>Mnv\Core\Collections\Collection</kbd> предоставляет свободную и удобную оболочку для работы с массивами данных.
								Например, ознакомьтесь со следующим кодом.
								Мы будем использовать помощник <kbd>collect()</kbd> для создания нового экземпляра <kbd>Сollection</kbd> из массива, запуска функции <kbd>strtoupper</kbd> для каждого элемента, а затем удаления всех пустых элементов:</p>

							<pre class="language-php mb-2">
								<code>
$collection = collect(['taylor', 'abigail', null])->map(function (string $name) {
    return strtoupper($name);
})->reject(function (string $name) {
	return empty($name);
});
								</code>
							</pre>
							<p>Как вы можете видеть, класс <kbd>Collection</kbd> позволяет вам связать его методы в цепочку для выполнения плавного сопоставления и уменьшения базового массива.
								В общем случае коллекции неизменяемы, что означает, что каждый метод <kbd>Collection</kbd> возвращает совершенно новый экземпляр <kbd>Collection</kbd>.</p>
							<h6 class="fw-semibold" id="creating-collections">Создание коллекций</h6>
							<p>Как упоминалось выше, помощник <kbd>collect</kbd> возвращает новый экземпляр <kbd>Mnv\Core\Collections\Collection</kbd> для данного массива. Итак, создать коллекцию так же просто, как:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3]);
								</code>
							</pre>
							<div class="alert bg-info text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-info"></i></span>
								<span class="fw-semibold">Примечание!</span> Результаты запросов всегда возвращаются в виде `Collection` экземпляров.
							</div>

							<div class="mb-3">
								<h6 class="fw-semibold" id="extending-collections">Расширение коллекций</h6>
								<p>Коллекции являются "macroable", что позволяет вам добавлять дополнительные методы к классу Collection во время выполнения.
									Macro метод класса <kbd>Mnv\Core\Collections\Collection</kbd> принимает закрытие, которое будет выполнено при вызове вашего <kbd>macro</kbd>.
									Закрытие макроса может получить доступ к другим методам коллекции через <kbd>$this</kbd>, точно так же, как если бы это был реальный метод класса collection.<br>
									Например, следующий код добавляет метод <code>toUpper()</code> к классу <kbd>Collection</kbd>:
								</p>
								<pre class="language-php mb-2">
									<code>
use Mnv\Core\Collections\Collection;

Collection::macro('toUpper', function () {
	return $this->map(function (string $value) {
		return strtoupper($value);
	});
});

$collection = collect(['first', 'second']);

$upper = $collection->toUpper();

// ['FIRST', 'SECOND']
									</code>
								</pre>
							</div>

						</div>

						<div class="mb-4">
							<h6 class="fw-semibold" id="available-methods">Доступные методы</h6>
							<p class="mb-3">В большей части оставшейся документации коллекции мы обсудим каждый метод, доступный в классе <kbd>Collection</kbd>.<br>
								Помните, что все эти методы могут быть объединены в цепочку для плавного управления базовым массивом.
								Кроме того, почти каждый метод возвращает новый <kbd>Collection</kbd> экземпляр, что позволяет при необходимости сохранить исходную копию коллекции:
							</p>

							<div class="mb-3">
								<ul class="list-inline mb-0">
									<li class="list-inline-item"><a href="#method-all">all</a></li>
									<li class="list-inline-item"><a href="#method-average">average</a></li>
									<li class="list-inline-item"><a href="#method-avg">avg</a></li>
									<li class="list-inline-item"><a href="#method-chunk">chunk</a></li>
									<li class="list-inline-item"><a href="#method-chunkWhile">chunkWhile</a></li>
									<li class="list-inline-item"><a href="#method-collapse">collapse</a></li>
									<li class="list-inline-item"><a href="#method-collect">collect</a></li>
									<li class="list-inline-item"><a href="#method-combine">combine</a></li>
									<li class="list-inline-item"><a href="#method-concat">concat</a></li>
									<li class="list-inline-item"><a href="#method-contains">contains</a></li>
									<li class="list-inline-item"><a href="#method-containsStrict">containsStrict</a></li>
									<li class="list-inline-item"><a href="#method-countBy">countBy</a></li>
									<li class="list-inline-item"><a href="#method-crossJoin">crossJoin</a></li>
									<li class="list-inline-item"><a href="#method-diff">diff</a></li>
									<li class="list-inline-item"><a href="#method-diffAssoc">diffAssoc</a></li>
									<li class="list-inline-item"><a href="#method-diffKeys">diffKeys</a></li>
									<li class="list-inline-item"><a href="#method-duplicates">duplicates</a></li>
									<li class="list-inline-item"><a href="#method-duplicatesStrict">duplicatesStrict</a></li>
									<li class="list-inline-item"><a href="#method-each">each</a></li>
									<li class="list-inline-item"><a href="#method-eachSpread">eachSpread</a></li>
									<li class="list-inline-item"><a href="#method-every">every</a></li>
									<li class="list-inline-item"><a href="#method-except">except</a></li>
									<li class="list-inline-item"><a href="#method-filter">filter</a></li>
									<li class="list-inline-item"><a href="#method-first">first</a></li>
									<li class="list-inline-item"><a href="#method-firstOrFail">firstOrFail</a></li>
									<li class="list-inline-item"><a href="#method-firstWhere">firstWhere</a></li>
									<li class="list-inline-item"><a href="#method-flatMap">flatMap</a></li>
									<li class="list-inline-item"><a href="#method-flip">flip</a></li>
									<li class="list-inline-item"><a href="#method-forPage">forPage</a></li>
									<li class="list-inline-item"><a href="#method-get">get</a></li>
									<li class="list-inline-item"><a href="#method-groupBy">groupBy</a></li>
									<li class="list-inline-item"><a href="#method-has">has</a></li>
									<li class="list-inline-item"><a href="#method-implode">implode</a></li>
									<li class="list-inline-item"><a href="#method-intersect">intersect</a></li>
									<li class="list-inline-item"><a href="#method-intersectAssoc">intersectAssoc</a></li>
									<li class="list-inline-item"><a href="#method-intersectByKeys">intersectByKeys</a></li>
									<li class="list-inline-item"><a href="#method-isEmpty">isEmpty</a></li>
									<li class="list-inline-item"><a href="#method-isNotEmpty">isNotEmpty</a></li>
									<li class="list-inline-item"><a href="#method-join">join</a></li>
									<li class="list-inline-item"><a href="#method-keyBy">keyBy</a></li>
									<li class="list-inline-item"><a href="#method-keys">keys</a></li>
									<li class="list-inline-item"><a href="#method-last">last</a></li>
									<li class="list-inline-item"><a href="#method-macro">macro</a></li>
									<li class="list-inline-item"><a href="#method-make">make</a></li>
									<li class="list-inline-item"><a href="#method-map">map</a></li>
									<li class="list-inline-item"><a href="#method-make">make</a></li>
									<li class="list-inline-item"><a href="#method-mapInto">mapInto</a></li>
									<li class="list-inline-item"><a href="#method-mapSpread">mapSpread</a></li>
									<li class="list-inline-item"><a href="#method-mapToGroups">mapToGroups</a></li>
									<li class="list-inline-item"><a href="#method-mapWithKeys">mapWithKeys</a></li>
									<li class="list-inline-item"><a href="#method-max">max</a></li>
									<li class="list-inline-item"><a href="#method-median">median</a></li>
									<li class="list-inline-item"><a href="#method-merge">merge</a></li>
									<li class="list-inline-item"><a href="#method-mergeRecursive">mergeRecursive</a></li>
									<li class="list-inline-item"><a href="#method-min">min</a></li>
									<li class="list-inline-item"><a href="#method-mode">mode</a></li>
									<li class="list-inline-item"><a href="#method-only">only</a></li>
									<li class="list-inline-item"><a href="#method-pad">pad</a></li>
									<li class="list-inline-item"><a href="#method-partition">partition</a></li>
									<li class="list-inline-item"><a href="#method-pipe">pipe</a></li>
									<li class="list-inline-item"><a href="#method-pluck">pluck</a></li>
									<li class="list-inline-item"><a href="#method-random">random</a></li>
									<li class="list-inline-item"><a href="#method-reduce">reduce</a></li>
									<li class="list-inline-item"><a href="#method-reject">reject</a></li>
									<li class="list-inline-item"><a href="#method-replace">replace</a></li>
									<li class="list-inline-item"><a href="#method-replaceRecursive">replaceRecursive</a></li>
									<li class="list-inline-item"><a href="#method-reverse">reverse</a></li>
									<li class="list-inline-item"><a href="#method-search">search</a></li>
									<li class="list-inline-item"><a href="#method-shuffle">shuffle</a></li>
									<li class="list-inline-item"><a href="#method-skip">skip</a></li>
									<li class="list-inline-item"><a href="#method-sole">sole</a></li>
									<li class="list-inline-item"><a href="#method-some">some</a></li>
									<li class="list-inline-item"><a href="#method-sort">sort</a></li>
									<li class="list-inline-item"><a href="#method-sortBy">sortBy</a></li>
									<li class="list-inline-item"><a href="#method-sortByDesc">sortByDesc</a></li>
									<li class="list-inline-item"><a href="#method-sortKeys">sortKeys</a></li>
									<li class="list-inline-item"><a href="#method-sortKeysDesc">sortKeysDesc</a></li>
									<li class="list-inline-item"><a href="#method-split">split</a></li>
									<li class="list-inline-item"><a href="#method-sum">sum</a></li>
									<li class="list-inline-item"><a href="#method-take">take</a></li>
									<li class="list-inline-item"><a href="#method-tap">tap</a></li>
									<li class="list-inline-item"><a href="#method-times">times</a></li>
									<li class="list-inline-item"><a href="#method-toArray">toArray</a></li>
									<li class="list-inline-item"><a href="#method-toJson">toJson</a></li>
									<li class="list-inline-item"><a href="#method-union">union</a></li>
									<li class="list-inline-item"><a href="#method-unique">unique</a></li>
									<li class="list-inline-item"><a href="#method-uniqueStrict">uniqueStrict</a></li>
									<li class="list-inline-item"><a href="#method-unless">unless</a></li>
									<li class="list-inline-item"><a href="#method-unlessEmpty">unlessEmpty</a></li>
									<li class="list-inline-item"><a href="#method-unlessNotEmpty">unlessNotEmpty</a></li>
									<li class="list-inline-item"><a href="#method-unwrap">unwrap</a></li>
									<li class="list-inline-item"><a href="#method-values">values</a></li>
									<li class="list-inline-item"><a href="#method-when">when</a></li>
									<li class="list-inline-item"><a href="#method-whenEmpty">whenEmpty</a></li>
									<li class="list-inline-item"><a href="#method-whenNotEmpty">whenNotEmpty</a></li>
									<li class="list-inline-item"><a href="#method-whereStrict">whereStrict</a></li>
									<li class="list-inline-item"><a href="#method-whereBetween">whereBetween</a></li>
									<li class="list-inline-item"><a href="#method-whereIn">whereIn</a></li>
									<li class="list-inline-item"><a href="#method-whereInStrict">whereInStrict</a></li>
									<li class="list-inline-item"><a href="#method-whereInstanceOf">whereInstanceOf</a></li>
									<li class="list-inline-item"><a href="#method-whereNotBetween">whereNotBetween</a></li>
									<li class="list-inline-item"><a href="#method-whereNotIn">whereNotIn</a></li>
									<li class="list-inline-item"><a href="#method-whereNotInStrict">whereNotInStrict</a></li>
									<li class="list-inline-item"><a href="#method-wrap">wrap</a></li>
									<li class="list-inline-item"><a href="#method-zip">zip</a></li>


								</ul>
							</div>
						</div>

						<div class="mb-4">
							<div class="mb-3">
								<h6 class="fw-semibold" id="method-all">all()</h6>
								<p>Метод <code>all()</code> возвращает базовый массив, представленный коллекцией:</p>
								<pre class="language-php mb-2">
									<code>
collect([1, 2, 3])->all();

// [1, 2, 3]
									</code>
								</pre>
							</div>
							<div class="mb-3">
								<h6 class="fw-semibold" id="method-average">average()</h6>
								<p>Псевдоним метода <a href="#method-avg">`avg`</a></p>
							</div>
							<div class="mb-3">
								<h6 class="fw-semibold" id="method-avg">avg()</h6>
								<p>Метод <code>avg()</code> возвращает среднее значение данного ключа:</p>
								<pre class="language-php mb-2">
									<code>
$average = collect([
	['foo' => 10],
    ['foo' => 10],
    ['foo' => 20],
    ['foo' => 40]
])->avg('foo');

// 20

$average = collect([1, 1, 2, 4])->avg();

// 2
									</code>
								</pre>
							</div>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-chunk">chunk()</h6>
							<p>Метод <code>chunk()</code> разбивает коллекцию на несколько меньших коллекций заданного размера:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5, 6, 7]);

$chunks = $collection->chunk(4);

$chunks->all();

// [[1, 2, 3, 4], [5, 6, 7]]
								</code>
							</pre>
							<p class="mb-2">Этот метод особенно полезен в представлениях при работе с сеточной системой, такой как <kbd>Bootstrap</kbd> .
								Например, представьте, что у вас есть коллекция моделей, которые вы хотите отобразить в виде сетки:
							</p>
							<pre class="language-php mb-2">
								<code>
foreach ($products->chunk(3) as $chunk)
	foreach ($chunk as $product)
		$product->name
	endforeach
endforeach
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-chunkWhile">chunkWhile()</h6>
							<p>Метод <code>chunkWhile()</code> разбивает коллекцию на несколько меньших коллекций на основе оценки данного обратного вызова.<br>
								Переменная `$chunk`, переданная замыканию, может использоваться для проверки предыдущего элемента:
							</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(str_split('AABBCCCD'));

$chunks = $collection->chunkWhile(function (string $value, int $key, Collection $chunk) {
	return $value === $chunk->last();
});

$chunks->all();

// [['A', 'A'], ['B', 'B'], ['C', 'C', 'C'], ['D']]
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-collapse">collapse()</h6>
							<p>Метод <code>collapse()</code> сворачивает коллекцию массивов в одну плоскую коллекцию:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	[1, 2, 3],
	[4, 5, 6],
	[7, 8, 9],
]);

$collapsed = $collection->collapse();

$collapsed->all();

// [1, 2, 3, 4, 5, 6, 7, 8, 9]
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-collect">collect()</h6>
							<p>Метод <code>collect()</code> возвращает новый <kbd>Collection</kbd> экземпляр с элементами, которые в настоящее время находятся в коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collectionA = collect([1, 2, 3]);

$collectionB = $collectionA->collect();

$collectionB->all();

// [1, 2, 3]
								</code>
							</pre>
							<p class="mb-2">Этот <code>collect()</code> метод в первую очередь полезен для преобразования <a href="#lazy-collections">lazy collections</a> в стандартные `Collection` экземпляры:</p>
							<pre class="language-php mb-3">
								<code>
$lazyCollection = LazyCollection::make(function () {
	yield 1;
	yield 2;
	yield 3;
});

$collection = $lazyCollection->collect();

get_class($collection);

// 'Mnv\Core\Collections\Collection'

$collection->all();

// [1, 2, 3]
								</code>
							</pre>
							<div class="alert bg-info text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-info"></i></span>
								<span class="fw-semibold">Примечание!</span> Этот `collect` метод особенно полезен, когда у вас есть экземпляр `Enumerable` не ленивого экземпляра коллекции, и вам нужен экземпляр.
								Поскольку `collect()` это часть Enumerable, вы можете смело использовать его для получения экземпляра `Collection`.
							</div>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-combine">combine()</h6>
							<p>Метод <code>combine()</code> объединяет значения коллекции в качестве ключей со значениями другого массива или коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['name', 'age']);

$combined = $collection->combine(['George', 29]);

$combined->all();

// ['name' => 'George', 'age' => 29]
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-concat">concat()</h6>
							<p>Метод <code>concat()</code> добавляет данные <kbd>array</kbd> или значения коллекции в конец другой коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['John Doe']);

$concatenated = $collection->concat(['Jane Doe'])->concat(['name' => 'Johnny Doe']);

$concatenated->all();

// ['John Doe', 'Jane Doe', 'Johnny Doe']
								</code>
							</pre>
							<p class="mb-2">Метод <code>concat()</code> численно переиндексирует ключи для элементов, объединенных в исходную коллекцию.
								Чтобы сохранить ключи в ассоциативных коллекциях, см. метод <a href="#method-merge">merge()</a>.</p>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-contains">contains()</h6>
							<p>Метод <code>contains()</code> определяет, содержит ли коллекция данный элемент. <br>
								Вы можете передать методу замыкание <code>contains()</code>, чтобы определить, существует ли в коллекции элемент, соответствующий данному критерию истинности:
							</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$collection->contains(function (int $value, int $key) {
	return $value > 5;
});

// false
								</code>
							</pre>
							<p class="mb-2">В качестве альтернативы вы можете передать строку методу <kbd>contains</kbd>, чтобы определить, содержит ли коллекция заданное значение элемента:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['name' => 'Desk', 'price' => 100]);

$collection->contains('Desk');

// true

$collection->contains('New York');

// false
								</code>
							</pre>
							<p class="mb-2">Вы также можете передать пару ключ/значение методу <kbd>contains</kbd>, который определит, существует ли данная пара в коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product' => 'Desk', 'price' => 200],
	['product' => 'Chair', 'price' => 100],
]);

$collection->contains('product', 'Bookcase');

// false
								</code>
							</pre>
							<p class="mb-2">Метод <code>contains()</code> использует «свободные» сравнения при проверке значений элементов, то есть строка с целочисленным значением будет считаться равной целому числу с тем же значением.
								Используйте <a href="#method-containsStrict">containsStrict</a> метод для фильтрации с использованием «строгих» сравнений.<br> Обратное см. <code>contains()</code> в методе <a href="#method-doesntContain">doesntContain()</a>.
							</p>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-containsOneItem">containsOneItem()</h6>
							<p>Метод <code>containsOneItem()</code> определяет, содержит ли коллекция один элемент:</p>
							<pre class="language-php mb-2">
								<code>
collect([])->containsOneItem();

// false

collect(['1'])->containsOneItem();

// true

collect(['1', '2'])->containsOneItem();

// false
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-containsStrict">containsStrict()</h6>
							<p>Этот метод имеет ту же сигнатуру, что и <a href="#method-contains">contains()</a> метод; однако все значения сравниваются с использованием «строгих» сравнений.</p>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-count">count()</h6>
							<p>Метод <code>count()</code> возвращает общее количество элементов в коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$collection->count();

// 4
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-countBy">countBy()</h6>
							<p>Метод <code>countBy()</code> подсчитывает вхождения значений в коллекцию. По умолчанию метод подсчитывает количество вхождений каждого элемента, что позволяет вам подсчитывать определенные «типы» элементов в коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 2, 2, 3]);

$counted = $collection->countBy();

$counted->all();

// [1 => 1, 2 => 3, 3 => 1]
								</code>
							</pre>
							<p class="mb-2">Вы передаете замыкание методу <code>countBy()</code> для подсчета всех элементов по пользовательскому значению:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['alice@gmail.com', 'bob@yahoo.com', 'carlos@gmail.com']);

$counted = $collection->countBy(function (string $email) {
	return substr(strrchr($email, "@"), 1);
});

$counted->all();

// ['gmail.com' => 2, 'yahoo.com' => 1]
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-crossJoin">crossJoin()</h6>
							<p>Метод <code>crossJoin()</code> объединяет значения коллекции среди заданных массивов или коллекций, возвращая декартово произведение со всеми возможными перестановками:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2]);

$matrix = $collection->crossJoin(['a', 'b']);

$matrix->all();

/*
[
	[1, 'a'],
	[1, 'b'],
	[2, 'a'],
	[2, 'b'],
]
*/

$collection = collect([1, 2]);

$matrix = $collection->crossJoin(['a', 'b'], ['I', 'II']);

$matrix->all();

/*
[
	[1, 'a', 'I'],
	[1, 'a', 'II'],
	[1, 'b', 'I'],
	[1, 'b', 'II'],
	[2, 'a', 'I'],
	[2, 'a', 'II'],
	[2, 'b', 'I'],
	[2, 'b', 'II'],
]
*/
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-diff">diff()</h6>
							<p>Метод <code>diff()</code> сравнивает коллекцию с другой коллекцией или простым PHP <kbd>array</kbd> на основе ее значений.
								Этот метод вернет значения в исходной коллекции, которых нет в данной коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$diff = $collection->diff([2, 4, 6, 8]);

$diff->all();

// [1, 3, 5]
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-diffAssoc">diffAssoc()</h6>
							<p>Метод <code>diffAssoc()</code> сравнивает коллекцию с другой коллекцией или простым PHP <kbd>array</kbd> на основе ее ключей и значений.
								Этот метод вернет пары ключ/значение в исходной коллекции, которых нет в данной коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'color' => 'orange',
	'type' => 'fruit',
	'remain' => 6,
]);

$diff = $collection->diffAssoc([
	'color' => 'yellow',
	'type' => 'fruit',
	'remain' => 3,
	'used' => 6,
]);

$diff->all();

// ['color' => 'orange', 'remain' => 6]
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-diffKeys">diffKeys()</h6>
							<p>Метод <code>diffKeys()</code> сравнивает коллекцию с другой коллекцией или простым PHP <kbd>array</kbd> на основе ее ключей.
								Этот метод вернет пары ключ/значение в исходной коллекции, которых нет в данной коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'one' => 10,
	'two' => 20,
	'three' => 30,
	'four' => 40,
	'five' => 50,
]);

$diff = $collection->diffKeys([
	'two' => 2,
	'four' => 4,
	'six' => 6,
	'eight' => 8,
]);

$diff->all();

// ['one' => 10, 'three' => 30, 'five' => 50]
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-doesntContain">doesntContain()</h6>
							<p>Метод <code>doesntContain()</code> определяет, содержит ли коллекция заданный элемент. Вы можете передать методу замыкание <kbd>doesntContain</kbd>,
								чтобы определить, не существует ли в коллекции элемента, соответствующего заданному тесту на истинность:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$collection->doesntContain(function (int $value, int $key) {
	return $value < 5;
});

// false
								</code>
							</pre>
							<p class="nb-2">В качестве альтернативы вы можете передать строку методу <code>doesntContain()</code>, чтобы определить, не содержит ли коллекция заданное значение элемента:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['name' => 'Desk', 'price' => 100]);

$collection->doesntContain('Table');

// true

$collection->doesntContain('Desk');

// false
								</code>
							</pre>
							<p class="nb-2">Вы также можете передать пару ключ/значение методу <code>doesntContain()</code>, который определит, не существует ли данная пара в коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product' => 'Desk', 'price' => 200],
	['product' => 'Chair', 'price' => 100],
]);

$collection->doesntContain('product', 'Bookcase');

// true
								</code>
							</pre>
							<p class="mb-2">Метод <code>doesntContain()</code> использует «свободные» сравнения при проверке значений элементов, то есть строка с целочисленным значением будет считаться равной целому числу с тем же значением.</p>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-duplicates">duplicates()</h6>
							<p>Метод <code>duplicates()</code> извлекает и возвращает повторяющиеся значения из коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['a', 'b', 'a', 'c', 'b']);

$collection->duplicates();

// [2 => 'a', 4 => 'b']
								</code>
							</pre>
							<p class="mb-2">Если коллекция содержит массивы или объекты, вы можете передать ключ атрибутов, которые вы хотите проверить на повторяющиеся значения:</p>
							<pre class="language-php mb-2">
								<code>
$employees = collect([
	['email' => 'abigail@example.com', 'position' => 'Developer'],
	['email' => 'james@example.com', 'position' => 'Designer'],
	['email' => 'victoria@example.com', 'position' => 'Developer'],
]);

$employees->duplicates('position');

// [2 => 'Developer']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-duplicatesStrict">duplicatesStrict()</h6>
							<p>Этот метод имеет ту же сигнатуру, что и <a href="#method-duplicates">duplicates()</a> метод; однако все значения сравниваются с использованием «строгих» сравнений.</p>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-each">each()</h6>
							<p>Метод <code>each()</code> перебирает элементы в коллекции и передает каждый элемент в замыкание:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$collection->each(function (int $item, int $key) {
	// ...
});
								</code>
							</pre>
							<p class="mb-2">Если вы хотите прекратить повторение элементов, вы можете вернуться <kbd>false</kbd> из закрытия:</p>
							<pre class="language-php mb-2">
								<code>
$collection->each(function (int $item, int $key) {
	if (/* condition */) {
		return false;
	}
});
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-eachSpread">eachSpread()</h6>
							<p>Метод <code>eachSpread()</code> перебирает элементы коллекции, передавая значение каждого вложенного элемента в заданный обратный вызов:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([['John Doe', 35], ['Jane Doe', 33]]);

$collection->eachSpread(function (string $name, int $age) {
	// ...
});
								</code>
							</pre>
							<p class="mb-2">Вы можете остановить перебор элементов, вернувшись <kbd>false</kbd> из обратного вызова:</p>
							<pre class="language-php mb-2">
								<code>
$collection->eachSpread(function (string $name, int $age) {
	return false;
});
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-every">every()</h6>
							<p>Метод <code>every()</code> метод можно использовать для проверки того, что все элементы коллекции проходят заданный тест на истинность:</p>
							<pre class="language-php mb-2">
								<code>
collect([1, 2, 3, 4])->every(function (int $value, int $key) {
	return $value > 2;
});

// false
								</code>
							</pre>
							<p class="mb-2">Если коллекция пуста, <code>every()</code> метод вернет <kbd>true</kbd>:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([]);

$collection->every(function (int $value, int $key) {
	return $value > 2;
});

// true
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-except">except()</h6>
							<p>Метод <code>except()</code> возвращает все элементы коллекции, кроме тех, у которых есть указанные ключи:</p>
							<pre class="language-php mb-2">
								<code>
collect([1, 2, 3, 4])->every(function (int $value, int $key) {
	return $value > 2;
});

// false
								</code>
							</pre>
							<p class="mb-2">Для инверсии <kbd>except</kbd> см. <a href="#method-only">only()</a> метод.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-filter">filter()</h6>
							<p>Метод <code>filter()</code> фильтрует коллекцию, используя заданный обратный вызов, оставляя только те элементы, которые проходят заданный тест на истинность:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$filtered = $collection->filter(function (int $value, int $key) {
	return $value > 2;
});

$filtered->all();

// [3, 4]
								</code>
							</pre>
							<p class="mb-2">Если обратный вызов не указан, все записи коллекции, эквивалентные <kbd>false</kbd>, будут удалены:</p>
							<pre class="language-php mb-2"><code>
$collection = collect([1, 2, 3, null, false, '', 0, []]);

$collection->filter()->all();

// [1, 2, 3]
							</code></pre>
							<p class="mb-2">Обратное см. <kbd>filter</kbd> в методе <a
										href="#method-reject">reject()</a>.</p>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-first">first()</h6>
							<p>Метод <code>first()</code> возвращает первый элемент в коллекции, который проходит
								заданный тест на истинность:</p>
							<pre class="language-php mb-2"><code>
collect([1, 2, 3, 4])->first(function (int $value, int $key) {
	return $value > 2;
});

// 3
							</code></pre>
							<p class="mb-2">Вы также можете вызвать <code>first()</code> метод без аргументов, чтобы получить первый элемент в коллекции. Если коллекция пуста, <kbd>null</kbd> возвращается:
							</p>
							<pre class="language-php mb-2"><code>
collect([1, 2, 3, 4])->first();

// 1
							</code></pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-firstOrFail">firstOrFail()</h6>
							<p>Метод <code>firstOrFail()</code> идентичен методу <code>first()</code>; однако, если результат не найден, <kbd>ItemNotFoundException</kbd> будет выдано исключение:</p>
							<pre class="language-php mb-2">
								<code>
collect([1, 2, 3, 4])->firstOrFail(function (int $value, int $key) {
	return $value > 5;
});

// Throws ItemNotFoundException...
								</code>
							</pre>
							<p class="mb-2">Вы также можете вызвать <code>firstOrFail()</code> метод без аргументов, чтобы получить первый элемент в коллекции.
								Если коллекция пуста, <kbd>ItemNotFoundException</kbd> будет выброшено исключение:</p>
							<pre class="language-php mb-2">
								<code>
collect([])->firstOrFail();

// Throws ItemNotFoundException...
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-firstWhere">firstWhere()</h6>
							<p>Метод <code>firstWhere()</code> возвращает первый элемент коллекции с заданной парой ключ/значение:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'Regena', 'age' => null],
	['name' => 'Linda', 'age' => 14],
	['name' => 'Diego', 'age' => 23],
	['name' => 'Linda', 'age' => 84],
]);

$collection->firstWhere('name', 'Linda');

// ['name' => 'Linda', 'age' => 14]
								</code>
							</pre>
							<p class="mb-2">Вы также можете вызвать <code>firstWhere()</code> метод с оператором сравнения:</p>
							<pre class="language-php mb-2">
								<code>
$collection->firstWhere('age', '>=', 18);

// ['name' => 'Diego', 'age' => 23]
								</code>
							</pre>
							<p class="mb-2">Как и в случае с методом <a href="#method-where">where()</a>, вы можете передать методу один аргумент <code>firstWhere()</code>.
								В этом сценарии <code>firstWhere()</code> метод вернет первый элемент, где значение данного ключа элемента является «истинным»:
							</p>
							<pre class="language-php mb-2">
								<code>
$collection->firstWhere('age');

// ['name' => 'Linda', 'age' => 14]
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-flatMap">flatMap()</h6>
							<p>Метод <code>flatMap()</code> выполняет итерацию по коллекции и передает каждое значение данному замыканию.<br>
								Закрытие может изменять элемент и возвращать его, таким образом формируя новую коллекцию измененных элементов. Затем массив выравнивается на один уровень:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'Sally'],
	['school' => 'Arkansas'],
	['age' => 28]
]);

$flattened = $collection->flatMap(function (array $values) {
	return array_map('strtoupper', $values);
});

$flattened->all();

// ['name' => 'SALLY', 'school' => 'ARKANSAS', 'age' => '28'];
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-flatten">flatten()</h6>
							<p>Метод <code>flatten()</code> сводит многомерную коллекцию в одно измерение:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'name' => 'taylor',
	'languages' => [
		'php', 'javascript'
	]
]);

$flattened = $collection->flatten();

$flattened->all();

// ['taylor', 'php', 'javascript'];
								</code>
							</pre>
							<p class="mb-2">При необходимости вы можете передать <code>flatten()</code> методу аргумент «глубина»:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'Apple' => [
		[
			'name' => 'iPhone 6S',
			'brand' => 'Apple'
		],
	],
	'Samsung' => [
		[
			'name' => 'Galaxy S7',
			'brand' => 'Samsung'
		],
	],
]);

$products = $collection->flatten(1);

$products->values()->all();

/*
	[
		['name' => 'iPhone 6S', 'brand' => 'Apple'],
		['name' => 'Galaxy S7', 'brand' => 'Samsung'],
	]
*/
								</code>
							</pre>
							<p class="mb-2">В этом примере вызов <code>flatten()</code> без указания глубины также сгладил бы вложенные массивы, что привело бы к ['iPhone 6S', 'Apple', 'Galaxy S7', 'Samsung'].
								Предоставление глубины позволяет вам указать количество уровней вложенных массивов, которые будут сведены.</p>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-flip">flip()</h6>
							<p>Метод <code>flip()</code> меняет местами ключи коллекции с их соответствующими значениями:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['name' => 'taylor', 'admin' => 'developer']);

$flipped = $collection->flip();

$flipped->all();

// ['taylor' => 'name', 'admin' => 'developer']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-forget">forget()</h6>
							<p>Метод <code>forget()</code> удаляет элемент из коллекции по его ключу:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['name' => 'taylor', 'admin' => 'developer']);

$collection->forget('name');

$collection->all();

// ['admin' => 'developer']
								</code>
							</pre>
							<div class="alert bg-warning text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-warning-circle"></i></span>
								<span class="fw-semibold">Предупреждение!</span> В отличие от большинства других методов, `forget` не возвращает новую измененную коллекцию; он изменяет вызываемую коллекцию.
							</div>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-forPage">forPage()</h6>
							<p>Метод <code>forPage()</code> возвращает новую коллекцию, содержащую элементы, которые должны присутствовать на странице с заданным номером. Метод принимает номер страницы в
								качестве первого аргумента и количество элементов, отображаемых на странице, в качестве второго аргумента:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5, 6, 7, 8, 9]);

$chunk = $collection->forPage(2, 3);

$chunk->all();

// [4, 5, 6]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-get">get()</h6>
							<p>Метод <code>get()</code> возвращает элемент по заданному ключу. Если ключ не существует, `null` возвращается:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['name' => 'taylor', 'admin' => 'developer']);

$value = $collection->get('name');

// taylor
								</code>
							</pre>
							<p class="mb-2">При желании вы можете передать значение по умолчанию в качестве второго аргумента:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['name' => 'taylor', 'admin' => 'developer']);

$value = $collection->get('age', 34);

// 34
								</code>
							</pre>
							<p class="mb-2">Вы даже можете передать обратный вызов в качестве значения метода по умолчанию. Результат обратного вызова будет возвращен, если указанный ключ не существует:</p>
							<pre class="language-php mb-2">
								<code>
$collection->get('email', function () {
	return 'taylor@example.com';
});

// taylor@example.com
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-groupBy">groupBy()</h6>
							<p>Метод <code>groupBy()</code> группирует элементы коллекции по заданному ключу:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['account_id' => 'account-x10', 'product' => 'Chair'],
	['account_id' => 'account-x10', 'product' => 'Bookcase'],
	['account_id' => 'account-x11', 'product' => 'Desk'],
]);

$grouped = $collection->groupBy('account_id');

$grouped->all();

/*
[
	'account-x10' => [
		['account_id' => 'account-x10', 'product' => 'Chair'],
		['account_id' => 'account-x10', 'product' => 'Bookcase'],
	],
	'account-x11' => [
		['account_id' => 'account-x11', 'product' => 'Desk'],
	],
]
*/
								</code>
							</pre>
							<p class="mb-2">Вместо передачи строки `key` вы можете передать обратный вызов. Обратный вызов должен возвращать значение, которое вы хотите ввести для группы:</p>
							<pre class="language-php mb-2">
								<code>
$grouped = $collection->groupBy(function (array $item, int $key) {
	return substr($item['account_id'], -3);
});

$grouped->all();

/*
[
	'x10' => [
		['account_id' => 'account-x10', 'product' => 'Chair'],
		['account_id' => 'account-x10', 'product' => 'Bookcase'],
	],
	'x11' => [
		['account_id' => 'account-x11', 'product' => 'Desk'],
	],
]
*/
								</code>
							</pre>
							<p class="mb-2">Несколько критериев группировки могут быть переданы в виде массива. Каждый элемент массива будет применяться к соответствующему уровню в многомерном массиве:</p>
							<pre class="language-php mb-2">
								<code>
$data = new Collection([
	10 => ['user' => 1, 'skill' => 1, 'roles' => ['Role_1', 'Role_3']],
	20 => ['user' => 2, 'skill' => 1, 'roles' => ['Role_1', 'Role_2']],
	30 => ['user' => 3, 'skill' => 2, 'roles' => ['Role_1']],
	40 => ['user' => 4, 'skill' => 2, 'roles' => ['Role_2']],
]);

$result = $data->groupBy(['skill', function (array $item) {
	return $item['roles'];
}], preserveKeys: true);

/*
[
	1 => [
		'Role_1' => [
			10 => ['user' => 1, 'skill' => 1, 'roles' => ['Role_1', 'Role_3']],
			20 => ['user' => 2, 'skill' => 1, 'roles' => ['Role_1', 'Role_2']],
		],
		'Role_2' => [
			20 => ['user' => 2, 'skill' => 1, 'roles' => ['Role_1', 'Role_2']],
		],
		'Role_3' => [
			10 => ['user' => 1, 'skill' => 1, 'roles' => ['Role_1', 'Role_3']],
		],
	],
	2 => [
		'Role_1' => [
			30 => ['user' => 3, 'skill' => 2, 'roles' => ['Role_1']],
		],
		'Role_2' => [
			40 => ['user' => 4, 'skill' => 2, 'roles' => ['Role_2']],
		],
	],
];
*/
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-has">has()</h6>
							<p>Метод <code>has()</code> определяет, существует ли данный ключ в коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['account_id' => 1, 'product' => 'Desk', 'amount' => 5]);

$collection->has('product');

// true

$collection->has(['product', 'amount']);

// true

$collection->has(['amount', 'price']);

// false
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-hasAny">hasAny()</h6>
							<p>Метод <code>hasAny()</code> определяет, существует ли какой-либо из заданных ключей в коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['account_id' => 1, 'product' => 'Desk', 'amount' => 5]);

$collection->hasAny(['product', 'price']);

// true

$collection->hasAny(['name', 'price']);

// false
								</code>
							</pre>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-implode">implode()</h6>
							<p>Метод <code>implode()</code> объединяет элементы в коллекцию. Его аргументы зависят от
								типа элементов в коллекции. Если коллекция содержит массивы или объекты, вы должны
								передать ключ атрибутов, которые вы хотите соединить, и строку «склеивания», которую вы
								хотите поместить между значениями:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['account_id' => 1, 'product' => 'Desk'],
	['account_id' => 2, 'product' => 'Chair'],
]);

$collection->implode('product', ', ');

// Desk, Chair
								</code>
							</pre>
							<p class="mb-2">Если коллекция содержит простые строки или числовые значения, вы должны передать «клей» в качестве единственного аргумента метода:</p>
							<pre class="language-php mb-2">
								<code>
collect([1, 2, 3, 4, 5])->implode('-');

// '1-2-3-4-5'
								</code>
							</pre>
							<p class="mb-2">Вы можете передать методу замыкание, <code>implode()</code> если хотите отформатировать значения, которые будут сжаты:</p>
							<pre class="language-php mb-2">
								<code>
$collection->implode(function (array $item, int $key) {
	return strtoupper($item['product']);
}, ', ');

// DESK, CHAIR
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-intersect">intersect()</h6>
							<p>Метод <code>intersect()</code> удаляет все значения из исходной коллекции, которых нет в заданной <kbd>array</kbd> или коллекции. Полученная коллекция сохранит ключи исходной коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['Desk', 'Sofa', 'Chair']);

$intersect = $collection->intersect(['Desk', 'Chair', 'Bookcase']);

$intersect->all();

// [0 => 'Desk', 2 => 'Chair']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-intersectAssoc">intersectAssoc()</h6>
							<p>Метод <code>intersectAssoc()</code> сравнивает исходную коллекцию с другой коллекцией или <kbd>array</kbd>, возвращая пары ключ/значение, присутствующие во всех заданных коллекциях:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'color' => 'red',
	'size' => 'M',
	'material' => 'cotton'
]);

$intersect = $collection->intersectAssoc([
	'color' => 'blue',
	'size' => 'M',
	'material' => 'polyester'
]);

$intersect->all();

// ['size' => 'M']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-intersectByKeys">intersectByKeys()</h6>
							<p>Метод <code>intersectByKeys()</code> удаляет любые ключи и соответствующие им значения из исходной коллекции, которых нет в заданной <kbd>array</kbd> или коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'serial' => 'UX301', 'type' => 'screen', 'year' => 2009,
]);

$intersect = $collection->intersectByKeys([
	'reference' => 'UX404', 'type' => 'tab', 'year' => 2011,
]);

$intersect->all();

// ['type' => 'screen', 'year' => 2009]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-isEmpty">isEmpty()</h6>
							<p>Метод <code>isEmpty()</code> возвращает значение <kbd>true</kbd>, если коллекция пуста; в противном случае <kbd>false</kbd> возвращается:</p>
							<pre class="language-php mb-2">
								<code>
collect([])->isEmpty();

// true
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-isNotEmpty">isNotEmpty()</h6>
							<p>Метод <code>isNotEmpty()</code> возвращает значение <kbd>true</kbd>, если коллекция не пуста; в противном случае <kbd>false</kbd> возвращается:</p>
							<pre class="language-php mb-2">
								<code>
collect([])->isNotEmpty();

// false
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-join">join()</h6>
							<p>Метод <code>join()</code> объединяет значения коллекции строкой. Используя второй аргумент этого метода, вы также можете указать, как последний элемент должен быть добавлен к строке:</p>
							<pre class="language-php mb-2">
								<code>
collect(['a', 'b', 'c'])->join(', '); // 'a, b, c'
collect(['a', 'b', 'c'])->join(', ', ', and '); // 'a, b, and c'
collect(['a', 'b'])->join(', ', ' and '); // 'a and b'
collect(['a'])->join(', ', ' and '); // 'a'
collect([])->join(', ', ' and '); // ''
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-keyBy">keyBy()</h6>
							<p>Метод <code>keyBy()</code> вводит коллекцию по заданному ключу. Если несколько элементов имеют один и тот же ключ, в новой коллекции появится только последний:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product_id' => 'prod-100', 'name' => 'Desk'],
	['product_id' => 'prod-200', 'name' => 'Chair'],
]);

$keyed = $collection->keyBy('product_id');

$keyed->all();

/*
[
	'prod-100' => ['product_id' => 'prod-100', 'name' => 'Desk'],
	'prod-200' => ['product_id' => 'prod-200', 'name' => 'Chair'],
]
*/
								</code>
							</pre>
							<p class="mb-2">Вы также можете передать обратный вызов методу. Обратный вызов должен возвращать значение для ключа коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$keyed = $collection->keyBy(function (array $item, int $key) {
	return strtoupper($item['product_id']);
});

$keyed->all();

/*
[
	'PROD-100' => ['product_id' => 'prod-100', 'name' => 'Desk'],
	'PROD-200' => ['product_id' => 'prod-200', 'name' => 'Chair'],
]
*/
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-keys">keys()</h6>
							<p>Метод <code>keys()</code> возвращает все ключи коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'prod-100' => ['product_id' => 'prod-100', 'name' => 'Desk'],
	'prod-200' => ['product_id' => 'prod-200', 'name' => 'Chair'],
]);

$keys = $collection->keys();

$keys->all();

// ['prod-100', 'prod-200']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-last">last()</h6>
							<p>Метод <code>last()</code> возвращает последний элемент в коллекции, который проходит заданный тест на истинность:</p>
							<pre class="language-php mb-2">
								<code>
collect([1, 2, 3, 4])->last(function (int $value, int $key) {
	return $value < 3;
});

// 2
								</code>
							</pre>
							<p class="mb-2">Вы также можете вызвать <code>last()<</code> метод без аргументов, чтобы получить последний элемент в коллекции. Если коллекция пуста, <kbd>null</kbd> возвращается:</p>
							<pre class="language-php mb-2">
								<code>
collect([1, 2, 3, 4])->last();

// 4
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-lazy">lazy()</h6>
							<p>Метод <code>lazy()</code> возвращает новый <a href="#lazy-collections">LazyCollection</a> экземпляр из базового массива элементов:</p>
							<pre class="language-php mb-2">
								<code>
$lazyCollection = collect([1, 2, 3, 4])->lazy();

get_class($lazyCollection);

// Mnv\Core\Collections\LazyCollection

$lazyCollection->all();

// [1, 2, 3, 4]
								</code>
							</pre>
							<p class="mb-2">Это особенно полезно, когда вам нужно выполнить преобразования на огромном
								<kbd>Collection</kbd>, содержащем много элементов:</p>
							<pre class="language-php mb-2">
								<code>
$count = $hugeCollection
	->lazy()
	->where('country', 'FR')
	->where('balance', '>', '100')
	->count();
								</code>
							</pre>
							<p class="mb-2">Преобразовывая коллекцию в <kbd>LazyCollection</kbd>, мы избегаем выделения
								тонны дополнительной памяти. Хотя исходная коллекция по-прежнему хранит свои значения в
								памяти, последующие фильтры этого не сделают. Поэтому при фильтрации результатов
								коллекции практически не выделяется дополнительная память.</p>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-macro">macro()</h6>
							<p>Статический <code>macro()</code> метод позволяет добавлять методы в <kbd>Collection</kbd>класс во время выполнения. Обратитесь к документации по <a href="#extending-collections">расширяющиеся коллекции</a> для получения дополнительной информации. </p>

						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-make">make()</h6>
							<p>Статический <code>make()</code> метод создает новый экземпляр коллекции. См. раздел <a href="#creating-collections">Создание коллекций</a>.</p>

						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-map">map()</h6>
							<p>Метод <code>map()</code> перебирает коллекцию и передает каждое значение заданному обратному вызову. Обратный вызов может изменять элемент и возвращать его, таким образом формируя новую коллекцию измененных элементов:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$multiplied = $collection->map(function (int $item, int $key) {
	return $item * 2;
});

$multiplied->all();

// [2, 4, 6, 8, 10]
								</code>
							</pre>
							<div class="alert bg-warning text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-warning-circle"></i></span>
								<span class="fw-semibold">Предупреждение!</span> Как и большинство других методов коллекции, `map()` возвращает новый экземпляр коллекции; он не изменяет вызываемую
								коллекцию. Если вы хотите преобразовать исходную коллекцию, используйте <a href="#method-transform" class="alert-link text-reset">transform()</a>.
							</div>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-mapInto">mapInto()</h6>
							<p>Метод <code>mapInto()</code> перебирает коллекцию, создавая новый экземпляр данного класса, передавая значение в конструктор:</p>
							<pre class="language-php mb-2">
								<code>
class Currency
{
	/**
	* Create a new currency instance.
	*/
	function __construct(
		public string $code
	) { }
}

$collection = collect(['USD', 'EUR', 'GBP']);

$currencies = $collection->mapInto(Currency::class);

$currencies->all();

// [Currency('USD'), Currency('EUR'), Currency('GBP')]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-mapSpread">mapSpread()</h6>
							<p>Метод <code>mapSpread()</code> выполняет итерацию по элементам коллекции, передавая значение каждого вложенного элемента в данное замыкание. Закрытие может изменять элемент
								и возвращать его, таким образом формируя новую коллекцию измененных элементов:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([0, 1, 2, 3, 4, 5, 6, 7, 8, 9]);

$chunks = $collection->chunk(2);

$sequence = $chunks->mapSpread(function (int $even, int $odd) {
	return $even + $odd;
});

$sequence->all();

// [1, 5, 9, 13, 17]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-mapToGroups">mapToGroups()</h6>
							<p>Метод <code>mapToGroups()</code> группирует элементы коллекции по заданному замыканию.
								Замыкание должно возвращать ассоциативный массив, содержащий одну пару ключ/значение, таким образом формируя новую коллекцию сгруппированных значений:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	[
		'name' => 'John Doe',
		'department' => 'Sales',
	],
	[
		'name' => 'Jane Doe',
		'department' => 'Sales',
	],
	[
		'name' => 'Johnny Doe',
		'department' => 'Marketing',
	]
]);

$grouped = $collection->mapToGroups(function (array $item, int $key) {
	return [$item['department'] => $item['name']];
});

$grouped->all();

/*
[
	'Sales' => ['John Doe', 'Jane Doe'],
	'Marketing' => ['Johnny Doe'],
]
*/

$grouped->get('Sales')->all();

// ['John Doe', 'Jane Doe']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-mapWithKeys">mapWithKeys()</h6>
							<p>Метод <code>mapWithKeys()</code> перебирает коллекцию и передает каждое значение
								заданному обратному вызову. Обратный вызов должен возвращать ассоциативный массив, содержащий одну пару ключ/значение:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	[
		'name' => 'John',
		'department' => 'Sales',
		'email' => 'john@example.com',
	],
	[
		'name' => 'Jane',
		'department' => 'Marketing',
		'email' => 'jane@example.com',
	]
]);

$keyed = $collection->mapWithKeys(function (array $item, int $key) {
	return [$item['email'] => $item['name']];
});

$keyed->all();

/*
[
	'john@example.com' => 'John',
	'jane@example.com' => 'Jane',
]
*/
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-max">max()</h6>
							<p>Метод <code>max()</code> возвращает максимальное значение данного ключа:</p>
							<pre class="language-php mb-2">
								<code>
$max = collect([
	['foo' => 10],
	['foo' => 20]
])->max('foo');

// 20

$max = collect([1, 2, 3, 4, 5])->max();

// 5
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-median">median()</h6>
							<p>Метод <code>median()</code> возвращает <a href="https://en.wikipedia.org/wiki/Median" target="_blank">median value</a> данного ключа:
							</p>
							<pre class="language-php mb-2">
								<code>
$median = collect([
	['foo' => 10],
	['foo' => 10],
	['foo' => 20],
	['foo' => 40]
])->median('foo');

// 15

$median = collect([1, 1, 2, 4])->median();

// 1.5
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-merge">merge()</h6>
							<p>Метод <code>merge()</code> объединяет данный массив или коллекцию с исходной коллекцией.
								Если строковый ключ в данных элементах соответствует строковому ключу в исходной коллекции, значение данного элемента перезапишет значение в исходной коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['product_id' => 1, 'price' => 100]);

$merged = $collection->merge(['price' => 200, 'discount' => false]);

$merged->all();

// ['product_id' => 1, 'price' => 200, 'discount' => false]
								</code>
							</pre>
							<p class="mb-2">Если ключи данного элемента являются числовыми, значения будут добавлены в конец коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['Desk', 'Chair']);

$merged = $collection->merge(['Bookcase', 'Door']);

$merged->all();

// ['Desk', 'Chair', 'Bookcase', 'Door']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-mergeRecursive">mergeRecursive()</h6>
							<p>Метод <code>mergeRecursive()</code> рекурсивно объединяет данный массив или коллекцию с исходной коллекцией. Если строковый ключ в заданных элементах совпадает со строковым
								ключом в исходной коллекции, то значения этих ключей объединяются в массив, и это делается рекурсивно:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['product_id' => 1, 'price' => 100]);

$merged = $collection->mergeRecursive([
	'product_id' => 2,
	'price' => 200,
	'discount' => false
]);

$merged->all();

// ['product_id' => [1, 2], 'price' => [100, 200], 'discount' => false]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-min">min()</h6>
							<p>Метод <code>min()</code> возвращает минимальное значение данного ключа:</p>
							<pre class="language-php mb-2">
								<code>
$min = collect([['foo' => 10], ['foo' => 20]])->min('foo');

// 10

$min = collect([1, 2, 3, 4, 5])->min();

// 1
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-mode">mode()</h6>
							<p>Метод <code>mode()</code> возвращает <a href="https://en.wikipedia.org/wiki/Mode_(statistics)" target="_blank">mode value</a> данного ключа::</p>
							<pre class="language-php mb-2">
								<code>
$mode = collect([
	['foo' => 10],
	['foo' => 10],
	['foo' => 20],
	['foo' => 40]
])->mode('foo');

// [10]

$mode = collect([1, 1, 2, 4])->mode();

// [1]

$mode = collect([1, 1, 2, 2])->mode();

// [1, 2]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-nth">nth()</h6>
							<p>Метод <code>nth()</code> создает новую коллекцию, состоящую из каждого n-го элемента:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['a', 'b', 'c', 'd', 'e', 'f']);

$collection->nth(4);

// ['a', 'e']
								</code>
							</pre>
							<p class="mb-2">При желании вы можете передать начальное смещение в качестве второго аргумента:</p>
							<pre class="language-php mb-2">
								<code>
$collection->nth(4, 1);

// ['b', 'f']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-only">only()</h6>
							<p>Метод <code>only()</code> возвращает элементы коллекции с указанными ключами:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'product_id' => 1,
	'name' => 'Desk',
	'price' => 100,
	'discount' => false
]);

$filtered = $collection->only(['product_id', 'name']);

$filtered->all();

// ['product_id' => 1, 'name' => 'Desk']
								</code>
							</pre>
							<p class="mb-2">Для обратного значения <code>only()</code> см. метод <a href="#method-except">except()</a>.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-pad">pad()</h6>
							<p>Метод <code>pad()</code> будет заполнять массив заданным значением, пока массив не достигнет указанного размера. Этот метод ведет себя как PHP-функция <a href="https://secure.php.net/manual/en/function.array-pad.php" target="_blank">array_pad</a>.<br>
								Чтобы отступить влево, вы должны указать отрицательный размер. Заполнение не произойдет, если абсолютное значение заданного размера меньше или равно длине массива:
							</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['A', 'B', 'C']);

$filtered = $collection->pad(5, 0);

$filtered->all();

// ['A', 'B', 'C', 0, 0]

$filtered = $collection->pad(-5, 0);

$filtered->all();

// [0, 0, 'A', 'B', 'C']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-partition">partition()</h6>
							<p>Метод <code>partition()</code> метод можно комбинировать с деструктуризацией массива PHP, чтобы отделить элементы, которые проходят заданный тест на истинность, от тех, которые не проходят:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5, 6]);

[$underThree, $equalOrAboveThree] = $collection->partition(function (int $i) {
	return $i < 3;
});

$underThree->all();

// [1, 2]

$equalOrAboveThree->all();

// [3, 4, 5, 6]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-pipe">pipe()</h6>
							<p>Метод <code>pipe()</code> передает коллекцию заданному замыканию и возвращает результат выполненного замыкания:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3]);

$piped = $collection->pipe(function (Collection $collection) {
	return $collection->sum();
});

// 6
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-pipeInto">pipeInto()</h6>
							<p>Метод <code>pipeInto()</code> создает новый экземпляр данного класса и передает коллекцию в конструктор:</p>
							<pre class="language-php mb-2">
								<code>
class ResourceCollection
{
	/**
	* Create a new ResourceCollection instance.
	*/
	public function __construct(
		public Collection $collection,
	) { }
}

$collection = collect([1, 2, 3]);

$resource = $collection->pipeInto(ResourceCollection::class);

$resource->collection->all();

// [1, 2, 3]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-pipeThrough">pipeThrough()</h6>
							<p>Метод <code>pipeThrough()</code> передает коллекцию заданному массиву замыканий и возвращает результат выполненных замыканий:</p>
							<pre class="language-php mb-2">
								<code>
use Mnv\Core\Collections\Collection;

$collection = collect([1, 2, 3]);

$result = $collection->pipeThrough([
	function (Collection $collection) {
		return $collection->merge([4, 5]);
	},
	function (Collection $collection) {
		return $collection->sum();
	},
]);

// 15
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-pluck">pluck()</h6>
							<p>Метод <code>pluck()</code> извлекает все значения для данного ключа:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product_id' => 'prod-100', 'name' => 'Desk'],
	['product_id' => 'prod-200', 'name' => 'Chair'],
]);

$plucked = $collection->pluck('name');

$plucked->all();

// ['Desk', 'Chair']
								</code>
							</pre>
							<p class="mb-2">Вы также можете указать, как вы хотите, чтобы результирующая коллекция была снабжена ключами:</p>
							<pre class="language-php mb-2">
								<code>
$plucked = $collection->pluck('name', 'product_id');

$plucked->all();

// ['prod-100' => 'Desk', 'prod-200' => 'Chair']
								</code>
							</pre>
							<p class="mb-2">Метод <code>pluck()</code> также поддерживает извлечение вложенных значений с использованием «точечной» нотации:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	[
		'name' => 'Laracon',
		'speakers' => [
			'first_day' => ['Rosa', 'Judith'],
		],
	],
	[
		'name' => 'VueConf',
		'speakers' => [
			'first_day' => ['Abigail', 'Joey'],
		],
	],
]);

$plucked = $collection->pluck('speakers.first_day');

$plucked->all();

// [['Rosa', 'Judith'], ['Abigail', 'Joey']]
								</code>
							</pre>
							<p class="mb-2">Если дублирующиеся ключи существуют, последний совпадающий элемент будет вставлен в извлеченную коллекцию:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['brand' => 'Tesla',  'color' => 'red'],
	['brand' => 'Pagani', 'color' => 'white'],
	['brand' => 'Tesla',  'color' => 'black'],
	['brand' => 'Pagani', 'color' => 'orange'],
]);

$plucked = $collection->pluck('color', 'brand');

$plucked->all();

// ['Tesla' => 'black', 'Pagani' => 'orange']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-pop">pop()</h6>
							<p>Метод <code>pop()</code> удаляет и возвращает последний элемент из коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$collection->pop();

// 5

$collection->all();

// [1, 2, 3, 4]
								</code>
							</pre>
							<p class="mb-2">Вы можете передать методу целое число <code>pop()</code>, чтобы удалить и
								вернуть несколько элементов из конца коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$collection->pop(3);

// collect([5, 4, 3])

$collection->all();

// [1, 2]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-prepend">prepend()</h6>
							<p>Метод <code>prepend()</code> добавляет элемент в начало коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$collection->prepend(0);

$collection->all();

// [0, 1, 2, 3, 4, 5]
								</code>
							</pre>
							<p class="mb-2">Вы также можете передать второй аргумент, чтобы указать ключ добавленного
								элемента:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['one' => 1, 'two' => 2]);

$collection->prepend(0, 'zero');

$collection->all();

// ['zero' => 0, 'one' => 1, 'two' => 2]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-pull">pull()</h6>
							<p>Метод <code>pull()</code> удаляет и возвращает элемент из коллекции по его ключу:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['product_id' => 'prod-100', 'name' => 'Desk']);

$collection->pull('name');

// 'Desk'

$collection->all();

// ['product_id' => 'prod-100']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-push">push()</h6>
							<p>Метод <code>push()</code> добавляет элемент в конец коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$collection->push(5);

$collection->all();

// [1, 2, 3, 4, 5]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-put">put()</h6>
							<p>Метод <code>put()</code> устанавливает заданный ключ и значение в коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['product_id' => 1, 'name' => 'Desk']);

$collection->put('price', 100);

$collection->all();

// ['product_id' => 1, 'name' => 'Desk', 'price' => 100]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-random">random()</h6>
							<p>Метод <code>random()</code> возвращает случайный элемент из коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$collection->random();

// 4 - (retrieved randomly)
								</code>
							</pre>
							<p class="mb-2">Вы можете передать целое число, <code>random()</code> чтобы указать, сколько элементов вы хотите получить случайным образом.
								Коллекция элементов всегда возвращается при явной передаче количества элементов, которые вы хотите получить:</p>
							<pre class="language-php mb-2">
								<code>
$random = $collection->random(3);

$random->all();

// [2, 4, 5] - (retrieved randomly)
								</code>
							</pre>
							<p class="mb-2">Если в экземпляре коллекции меньше элементов, чем запрошено, <code>random()</code> метод выдаст ошибку <kbd>InvalidArgumentException</kbd>.</p>
							<p class="mb-2">Метод <code>random()</code> также принимает замыкание, которое получит текущий экземпляр коллекции:</p>
							<pre class="language-php mb-2">
								<code>
use Mnv\Core\Collections\Collection;

$random = $collection->random(fn (Collection $items) => min(10, count($items)));

$random->all();

// [1, 2, 3, 4, 5] - (retrieved randomly)
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-range">range()</h6>
							<p>Метод <code>range()</code> возвращает коллекцию, содержащую целые числа из указанного диапазона:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect()->range(3, 6);

$collection->all();

// [3, 4, 5, 6]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-reduce">reduce()</h6>
							<p>Метод <code>reduce()</code> сводит коллекцию к одному значению, передавая результат каждой итерации в последующую итерацию:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3]);

$total = $collection->reduce(function (int $carry, int $item) {
	return $carry + $item;
});

// 6
								</code>
							</pre>
							<p class="mb-2">Значение для <kbd>$carry</kbd> первой итерации равно <kbd>null</kbd>; однако вы можете указать его начальное значение, передав второй аргумент <code>reduce()</code>:
							</p>
							<pre class="language-php mb-2">
								<code>
$collection->reduce(function (int $carry, int $item) {
	return $carry + $item;
}, 4);

// 10
								</code>
							</pre>
							<p class="mb-2">Метод <code>reduce()</code> также передает ключи массива в ассоциативных коллекциях данному обратному вызову:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'usd' => 1400,
	'gbp' => 1200,
	'eur' => 1000,
]);

$ratio = [
	'usd' => 1,
	'gbp' => 1.37,
	'eur' => 1.22,
];

$collection->reduce(function (int $carry, int $value, int $key) use ($ratio) {
	return $carry + ($value * $ratio[$key]);
});

// 4264
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-reduceSpread">reduceSpread()</h6>
							<p>Метод <code>reduceSpread()</code> сводит коллекцию к массиву значений, передавая результаты каждой итерации в последующую итерацию. Этот метод аналогичен методу <a href="#method-reduce">reduce()</a> ; однако он может принимать несколько начальных значений:</p>
							<pre class="language-php mb-2">
								<code>
[$creditsRemaining, $batch] = Image::where('status', 'unprocessed')
	->get()
	->reduceSpread(function (int $creditsRemaining, Collection $batch, Image $image) {
		if ($creditsRemaining >= $image->creditsRequired()) {
			$batch->push($image);

			$creditsRemaining -= $image->creditsRequired();
		}

		return [$creditsRemaining, $batch];
	}, $creditsAvailable, collect());
								</code>
							</pre>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-reject">reject()</h6>
							<p>Метод <code>reject()</code> фильтрует коллекцию, используя данное замыкание.<br>
								Закрытие должно вернуться `true`, если элемент должен быть удален из результирующей
								коллекции:
							</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$filtered = $collection->reject(function (int $value, int $key) {
	return $value > 2;
});

$filtered->all();

// [1, 2]
								</code>
							</pre>
							<p class="mb-2">Об обратном методе <code>reject()</code> см. <a href="#method-filter">filter()</a>
								метод.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-replace">replace()</h6>
							<p>Метод <code>replace</code> ведет себя аналогично `merge`; однако в дополнение к перезаписи совпадающих элементов со строковыми ключами метод <kbd>replace</kbd> также перезапишет элементы в коллекции с совпадающими числовыми ключами:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['Taylor', 'Abigail', 'James']);

$replaced = $collection->replace([1 => 'Victoria', 3 => 'Finn']);

$replaced->all();

// ['Taylor', 'Victoria', 'James', 'Finn']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-replaceRecursive">replaceRecursive()</h6>
							<p>Этот метод работает как <code>replace()</code>, но он будет повторяться в массивах и применять тот же процесс замены к внутренним значениям: </p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'Taylor',
	'Abigail',
	[
		'James',
		'Victoria',
		'Finn'
	]
]);

$replaced = $collection->replaceRecursive([
	'Charlie',
	2 => [1 => 'King']
]);

$replaced->all();

// ['Charlie', 'Abigail', ['James', 'King', 'Finn']]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-reverse">reverse()</h6>
							<p>Метод <code>reverse()</code> меняет порядок элементов коллекции, сохраняя исходные ключи:
							</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['a', 'b', 'c', 'd', 'e']);

$reversed = $collection->reverse();

$reversed->all();

/*
[
	4 => 'e',
	3 => 'd',
	2 => 'c',
	1 => 'b',
	0 => 'a',
]
*/
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-search">search()</h6>
							<p>Метод <code>search()</code> ищет в коллекции заданное значение и возвращает его ключ, если он найден. Если элемент не найден, <kbd>false</kbd> возвращается:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([2, 4, 6, 8]);

$collection->search(4);

// 1
								</code>
							</pre>
							<p class="mb-2">Поиск выполняется с использованием «свободного» сравнения, то есть строка с целочисленным значением будет считаться равной целому числу того же значения.
								Чтобы использовать «строгое» сравнение, передайте <kbd>true</kbd> в качестве второго аргумента методу:</p>
							<pre class="language-php mb-2">
								<code>
collect([2, 4, 6, 8])->search('4', $strict = true);

// false
								</code>
							</pre>
							<p class="mb-2">В качестве альтернативы вы можете предоставить собственное замыкание для
								поиска первого элемента, прошедшего заданный тест на истинность:</p>
							<pre class="language-php mb-2">
								<code>
collect([2, 4, 6, 8])->search(function (int $item, int $key) {
	return $item > 5;
});

// 2
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-shift">shift()</h6>
							<p>Метод <code>shift()</code> удаляет и возвращает первый элемент из коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$collection->shift();

// 1

$collection->all();

// [2, 3, 4, 5]
								</code>
							</pre>
							<p class="mb-2">Вы можете передать методу целое число <code>shift()</code>, чтобы удалить и
								вернуть несколько элементов из начала коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$collection->shift(3);

// collect([1, 2, 3])

$collection->all();

// [4, 5]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-shuffle">shuffle()</h6>
							<p>Метод <code>shuffle()</code> случайным образом перемешивает элементы в коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$shuffled = $collection->shuffle();

$shuffled->all();

// [3, 2, 5, 1, 4] - (generated randomly)
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-skip">skip()</h6>
							<p>Метод <code>skip()</code> возвращает новую коллекцию с заданным количеством элементов, удаленных из начала коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5, 6, 7, 8, 9, 10]);

$collection = $collection->skip(4);

$collection->all();

// [5, 6, 7, 8, 9, 10]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-skipUntil">skipUntil()</h6>
							<p>Метод <code>skipUntil()</code> пропускает элементы из коллекции до тех пор, пока данный обратный вызов не вернется, <kbd>true</kbd> а затем возвращает оставшиеся элементы в коллекции как новый экземпляр коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$subset = $collection->skipUntil(function (int $item) {
	return $item >= 3;
});

$subset->all();

// [3, 4]
								</code>
							</pre>
							<p class="mb-2">Вы также можете передать методу простое значение, <code>skipUntil()</code>чтобы пропустить все элементы, пока не будет найдено заданное значение:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$subset = $collection->skipUntil(3);

$subset->all();

// [3, 4]
								</code>
							</pre>
							<div class="alert bg-warning text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-warning-circle"></i></span>
								<span class="fw-semibold">Предупреждение!</span> Если заданное значение не найдено или обратный вызов никогда не возвращает значение `true`, `skipUntil()` метод вернет пустую коллекцию.
							</div>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-skipWhile">skipWhile()</h6>
							<p>Метод <code>skipWhile()</code> пропускает элементы из коллекции, пока возвращается данный обратный вызов, <kbd>true</kbd> а затем возвращает оставшиеся элементы в коллекции как новую коллекцию:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$subset = $collection->skipWhile(function (int $item) {
	return $item <= 3;
});

$subset->all();

// [4]
								</code>
							</pre>
							<div class="alert bg-warning text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-warning-circle"></i></span>
								<span class="fw-semibold">Предупреждение!</span> Если обратный вызов никогда не возвращает значение `false`, `skipWhile()` метод вернет пустую коллекцию.
							</div>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-slice">slice()</h6>
							<p>Метод <code>slice()</code> возвращает часть коллекции, начиная с заданного индекса:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5, 6, 7, 8, 9, 10]);

$slice = $collection->slice(4);

$slice->all();

// [5, 6, 7, 8, 9, 10]
								</code>
							</pre>
							<p class="mb-2">Если вы хотите ограничить размер возвращаемого фрагмента, передайте требуемый размер в качестве второго аргумента метода:</p>
							<pre class="language-php mb-2">
								<code>
$slice = $collection->slice(4, 2);

$slice->all();

// [5, 6]
								</code>
							</pre>
							<p class="mb-2">Возвращенный фрагмент будет сохранять ключи по умолчанию. Если вы не хотите сохранять исходные ключи, вы можете использовать <a href="#method-values">values()</a> метод их переиндексации.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-sliding">sliding()</h6>
							<p>Метод <code>sliding()</code> возвращает новую коллекцию фрагментов, представляющих «скользящее окно» элементов коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$chunks = $collection->sliding(2);

$chunks->toArray();

// [[1, 2], [2, 3], [3, 4], [4, 5]]
								</code>
							</pre>
							<p class="mb-2">Это особенно полезно в сочетании с <a href="#method-eachSpread">eachSpread()</a>методом:</p>
							<pre class="language-php mb-2">
								<code>
$transactions->sliding(2)->eachSpread(function (Collection $previous, Collection $current) {
	$current->total = $previous->total + $current->amount;
});
								</code>
							</pre>
							<p class="mb-2">При желании вы можете передать второе значение «шага», которое определяет расстояние между первым элементом каждого фрагмента:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$chunks = $collection->sliding(3, step: 2);

$chunks->toArray();

// [[1, 2, 3], [3, 4, 5]]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-sole">sole()</h6>
							<p>Метод <code>sole()</code> возвращает первый элемент в коллекции, который проходит заданный тест на истинность, но только если тест на истинность соответствует ровно одному элементу:</p>
							<pre class="language-php mb-2">
								<code>
collect([1, 2, 3, 4])->sole(function (int $value, int $key) {
	return $value === 2;
});

// 2
								</code>
							</pre>
							<p class="mb-2">Вы также можете передать пару ключ/значение в <code>sole()</code> метод, который вернет первый элемент в коллекции, который соответствует заданной паре, но только если совпадает ровно один элемент:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product' => 'Desk', 'price' => 200],
	['product' => 'Chair', 'price' => 100],
]);

$collection->sole('product', 'Chair');

// ['product' => 'Chair', 'price' => 100]
								</code>
							</pre>
							<p class="mb-2">В качестве альтернативы вы также можете вызвать <code>sole()</code> метод без аргументов, чтобы получить первый элемент в коллекции, если есть только один элемент:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product' => 'Desk', 'price' => 200],
]);

$collection->sole();

// ['product' => 'Desk', 'price' => 200]
								</code>
							</pre>
							<p class="mb-2">Если в коллекции нет элементов, которые должны быть возвращены методом <code>sole()</code>, <kbd>ItemNotFoundException</kbd> будет выдано исключение. Если должно быть возвращено более одного элемента, <kbd>MultipleItemsFoundException</kbd> будет выброшено.
							</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-some">some()</h6>
							<p>Псевдоним метода <a href="#method-contains">contains()</a>.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-sort">sort()</h6>
							<p>Метод <code>sort()</code> сортирует коллекцию. Отсортированная коллекция сохраняет
								исходные ключи массива, поэтому в следующем примере мы будем использовать <a href="#method-values">values()</a> метод для сброса ключей к последовательно пронумерованным индексам:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([5, 3, 1, 2, 4]);

$sorted = $collection->sort();

$sorted->values()->all();

// [1, 2, 3, 4, 5]
								</code>
							</pre>
							<p class="mb-2">Если ваши потребности в сортировке более сложны, вы можете передать обратный вызов <code>sort()</code> со своим собственным алгоритмом. Обратитесь к документации по
								PHP <a href="https://secure.php.net/manual/en/function.uasort.php#refsect1-function.uasort-parameters">uasort</a>, которая используется внутри вызовов методов коллекции <code>sort()</code>.</p>

							<div class="alert bg-info text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-info"></i></span>
								<span class="fw-semibold">Примечание!</span> Если вам нужно отсортировать коллекцию
								вложенных массивов или объектов, см. методы <a href="#method-sortBy" class="alert-link text-reset">sortBy()</a>
								и <a href="#method-sortByDesc" class="alert-link text-reset">sortByDesc()</a>.
							</div>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-sortBy">sortBy()</h6>
							<p>Метод <code>sortBy()</code> сортирует коллекцию по заданному ключу. Отсортированная коллекция сохраняет исходные ключи массива, поэтому в следующем примере мы будем
								использовать <a href="#method-values">values()</a> метод для сброса ключей к последовательно пронумерованным индексам:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'Desk', 'price' => 200],
	['name' => 'Chair', 'price' => 100],
	['name' => 'Bookcase', 'price' => 150],
]);

$sorted = $collection->sortBy('price');

$sorted->values()->all();

/*
[
	['name' => 'Chair', 'price' => 100],
	['name' => 'Bookcase', 'price' => 150],
	['name' => 'Desk', 'price' => 200],
]
*/
								</code>
							</pre>
							<p class="mb-2">Метод <code>sortBy()</code> принимает <a href="https://www.php.net/manual/en/function.sort.php">sort flags</a> в качестве второго аргумента:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['title' => 'Item 1'],
	['title' => 'Item 12'],
	['title' => 'Item 3'],
]);

$sorted = $collection->sortBy('title', SORT_NATURAL);

$sorted->values()->all();

/*
[
	['title' => 'Item 1'],
	['title' => 'Item 3'],
	['title' => 'Item 12'],
]
*/
								</code>
							</pre>
							<p class="mb-2">В качестве альтернативы вы можете передать собственное замыкание, чтобы определить, как сортировать значения коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'Desk', 'colors' => ['Black', 'Mahogany']],
	['name' => 'Chair', 'colors' => ['Black']],
	['name' => 'Bookcase', 'colors' => ['Red', 'Beige', 'Brown']],
]);

$sorted = $collection->sortBy(function (array $product, int $key) {
	return count($product['colors']);
});

$sorted->values()->all();

/*
[
	['name' => 'Chair', 'colors' => ['Black']],
	['name' => 'Desk', 'colors' => ['Black', 'Mahogany']],
	['name' => 'Bookcase', 'colors' => ['Red', 'Beige', 'Brown']],
]
*/
								</code>
							</pre>
							<p class="mb-2">Если вы хотите отсортировать свою коллекцию по нескольким атрибутам, вы можете передать методу массив операций сортировки <code>sortBy()</code>.
								Каждая операция сортировки должна быть массивом, состоящим из атрибута, по которому вы хотите отсортировать, и направления желаемой сортировки:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'Taylor Otwell', 'age' => 34],
	['name' => 'Abigail Otwell', 'age' => 30],
	['name' => 'Taylor Otwell', 'age' => 36],
	['name' => 'Abigail Otwell', 'age' => 32],
]);

$sorted = $collection->sortBy([
	['name', 'asc'],
	['age', 'desc'],
]);

$sorted->values()->all();

/*
[
	['name' => 'Abigail Otwell', 'age' => 32],
	['name' => 'Abigail Otwell', 'age' => 30],
	['name' => 'Taylor Otwell', 'age' => 36],
	['name' => 'Taylor Otwell', 'age' => 34],
]
*/
								</code>
							</pre>
							<p class="mb-2">При сортировке коллекции по нескольким атрибутам вы также можете предоставить замыкания, определяющие каждую операцию сортировки:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'Taylor Otwell', 'age' => 34],
	['name' => 'Abigail Otwell', 'age' => 30],
	['name' => 'Taylor Otwell', 'age' => 36],
	['name' => 'Abigail Otwell', 'age' => 32],
]);

$sorted = $collection->sortBy([
	fn (array $a, array $b) => $a['name'] <=> $b['name'],
	fn (array $a, array $b) => $b['age'] <=> $a['age'],
]);

$sorted->values()->all();

/*
[
	['name' => 'Abigail Otwell', 'age' => 32],
	['name' => 'Abigail Otwell', 'age' => 30],
	['name' => 'Taylor Otwell', 'age' => 36],
	['name' => 'Taylor Otwell', 'age' => 34],
]
*/
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-sortByDesc">sortByDesc()</h6>
							<p>Этот метод имеет ту же сигнатуру, что и <a href="#method-sortBy">sortBy()</a> метод, но сортирует коллекцию в обратном порядке. </p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-sortDesc">sortDesc()</h6>
							<p>Этот метод будет сортировать коллекцию в порядке, обратном методу <a href="#method-sort">sort()</a>:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([5, 3, 1, 2, 4]);

$sorted = $collection->sortDesc();

$sorted->values()->all();

// [5, 4, 3, 2, 1]
								</code>
							</pre>
							<p class="mb-2">В отличие от <code>sort()</code>, вы не можете передать замыкание в sortDesc.
								Вместо этого вы должны использовать <a href="#method-sort">sort()</a> метод и инвертировать сравнение.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-sortKeys">sortKeys()</h6>
							<p>Метод <code>sortKeys()</code> сортирует коллекцию по ключам базового ассоциативного
								массива:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'id'    => 22345,
	'first' => 'John',
	'last'  => 'Doe',
]);

$sorted = $collection->sortKeys();

$sorted->all();

/*
[
	'first' => 'John',
	'id'    => 22345,
	'last'  => 'Doe',
]
*/
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-sortKeysDesc">sortKeysDesc()</h6>
							<p>Этот метод имеет ту же сигнатуру, что и <a href="#method-sortKeys">sortKeys()</a> метод, но сортирует коллекцию в обратном порядке. </p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-sortKeysUsing">sortKeysUsing()</h6>
							<p>Метод <code>sortKeysUsing()</code> сортирует коллекцию по ключам базового ассоциативного массива с помощью обратного вызова:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	'ID' => 22345,
	'first' => 'John',
	'last' => 'Doe',
]);

$sorted = $collection->sortKeysUsing('strnatcasecmp');

$sorted->all();

/*
[
	'first' => 'John',
	'ID'   => 22345,
	'last'  => 'Doe',
]
*/
								</code>
							</pre>
							<p class="mb-2">Обратный вызов должен быть функцией сравнения, которая возвращает целое число, меньшее, равное или большее нуля.
								Для получения дополнительной информации обратитесь к документации по PHP <a href="https://www.php.net/manual/en/function.uksort.php#refsect1-function.uksort-parameters">uksort</a>,
								которая представляет собой функцию PHP, <code>sortKeysUsing()</code> используемую внутри метода.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-splice">splice()</h6>
							<p>Метод <code>splice()</code> удаляет и возвращает фрагмент элементов, начиная с указанного
								индекса:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$chunk = $collection->splice(2);

$chunk->all();

// [3, 4, 5]

$collection->all();

// [1, 2]
								</code>
							</pre>
							<p class="mb-2">Вы можете передать второй аргумент, чтобы ограничить размер результирующей коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$chunk = $collection->splice(2, 1);

$chunk->all();

// [3]

$collection->all();

// [1, 2, 4, 5]
								</code>
							</pre>
							<p class="mb-2">Кроме того, вы можете передать третий аргумент, содержащий новые элементы, чтобы заменить элементы, удаленные из коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$chunk = $collection->splice(2, 1, [10, 11]);

$chunk->all();

// [3]

$collection->all();

// [1, 2, 10, 11, 4, 5]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-split">split()</h6>
							<p>Метод <code>split()</code> разбивает коллекцию на заданное количество групп:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$groups = $collection->split(3);

$groups->all();

// [[1, 2], [3, 4], [5]]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-splitIn">splitIn()</h6>
							<p>Метод <code>splitIn()</code> разбивает коллекцию на заданное количество групп, полностью заполняя неконечные группы, прежде чем выделить остаток в последнюю группу:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5, 6, 7, 8, 9, 10]);

$groups = $collection->splitIn(3);

$groups->all();

// [[1, 2, 3, 4], [5, 6, 7, 8], [9, 10]]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-sum">sum()</h6>
							<p>Метод <code>sum()</code> возвращает сумму всех элементов коллекции:</p>
							<pre class="language-php mb-2">
								<code>
collect([1, 2, 3, 4, 5])->sum();

// 15
								</code>
							</pre>
							<p class="mb-2">Если коллекция содержит вложенные массивы или объекты, вы должны передать ключ, который будет использоваться для определения суммируемых значений:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'JavaScript: The Good Parts', 'pages' => 176],
	['name' => 'JavaScript: The Definitive Guide', 'pages' => 1096],
]);

$collection->sum('pages');

// 1272
								</code>
							</pre>
							<p class="mb-2">Кроме того, вы можете передать собственное замыкание, чтобы определить, какие значения коллекции суммировать:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'Chair', 'colors' => ['Black']],
	['name' => 'Desk', 'colors' => ['Black', 'Mahogany']],
	['name' => 'Bookcase', 'colors' => ['Red', 'Beige', 'Brown']],
]);

$collection->sum(function (array $product) {
	return count($product['colors']);
});

// 6
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-take">take()</h6>
							<p>Метод <code>take()</code> возвращает новую коллекцию с указанным количеством элементов:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([0, 1, 2, 3, 4, 5]);

$chunk = $collection->take(3);

$chunk->all();

// [0, 1, 2]
								</code>
							</pre>
							<p class="mb-2">Вы также можете передать отрицательное целое число, чтобы взять указанное количество элементов с конца коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([0, 1, 2, 3, 4, 5]);

$chunk = $collection->take(-2);

$chunk->all();

// [4, 5]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-takeUntil">takeUntil()</h6>
							<p>Метод <code>takeUntil()</code> возвращает элементы в коллекции до тех пор, пока данный обратный вызов не вернет <kbd>true</kbd>:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$subset = $collection->takeUntil(function (int $item) {
	return $item >= 3;
});

$subset->all();

// [1, 2]
								</code>
							</pre>
							<p class="mb-2">Вы также можете передать методу простое значение, <code>takeUntil()</code>
								чтобы получить элементы, пока не будет найдено заданное значение:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$subset = $collection->takeUntil(3);

$subset->all();

// [1, 2]
								</code>
							</pre>
							<div class="alert bg-warning text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-warning-circle"></i></span>
								<span class="fw-semibold">Предупреждение!</span> Если заданное значение не найдено или обратный вызов никогда не возвращает значение `true`, `takeUntil()` метод вернет все элементы коллекции.
							</div>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-takeWhile">takeWhile()</h6>
							<p>Метод <code>takeWhile()</code> возвращает элементы в коллекции до тех пор, пока данный обратный вызов не вернет <kbd>false</kbd>:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4]);

$subset = $collection->takeWhile(function (int $item) {
	return $item < 3;
});

$subset->all();

// [1, 2]
								</code>
							</pre>
							<div class="alert bg-warning text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-warning-circle"></i></span>
								<span class="fw-semibold">Предупреждение!</span> Если обратный вызов никогда не возвращает значение `false`, `takeWhile()` метод вернет все элементы коллекции.
							</div>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-tap">tap()</h6>
							<p>Метод <code>tap()</code> передает коллекцию заданному обратному вызову, позволяя вам «подключиться» к коллекции в определенной точке и сделать что-то с элементами, не затрагивая саму коллекцию.
								Затем коллекция возвращается методом `tap`:</p>
							<pre class="language-php mb-2">
								<code>
collect([2, 4, 3, 1, 5])
	->sort()
	->tap(function (Collection $collection) {
		Log::debug('Values after sorting', $collection->values()->all());
	})
	->shift();

// 1
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-times">times()</h6>
							<p>Метод <code>times()</code> метод создает новую коллекцию, вызывая данное замыкание указанное количество раз:</p>
							<pre class="language-php mb-2">
								<code>
$collection = Collection::times(10, function (int $number) {
	return $number * 9;
});

$collection->all();

// [9, 18, 27, 36, 45, 54, 63, 72, 81, 90]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-toArray">toArray()</h6>
							<p>Метод <code>toArray()</code> преобразует коллекцию в обычный PHP <kbd>array</kbd>. Если значениями коллекции являются модели объектом, модели также будут преобразованы в массивы:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['name' => 'Desk', 'price' => 200]);

$collection->toArray();

/*
[
	['name' => 'Desk', 'price' => 200],
]
*/
								</code>
							</pre>
							<div class="alert bg-warning text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-warning-circle"></i></span>
								<span class="fw-semibold">Предупреждение!</span> `toArray()` также преобразует все вложенные объекты коллекции, которые являются экземплярами, `Arrayable` в массив.
								Если вы хотите получить необработанный массив, лежащий в основе коллекции, используйте <a href="#method-all" class="alert-link text-reset">all()</a> вместо этого метода.
							</div>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-toJson">toJson()</h6>
							<p>Метод <code>toJson()</code> преобразует коллекцию в сериализованную строку `JSON`:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['name' => 'Desk', 'price' => 200]);

$collection->toJson();

// '{ "name":"Desk", "price":200 }'
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-transform">transform()</h6>
							<p>Метод <code>transform()</code> выполняет итерацию по коллекции и вызывает заданный обратный вызов для каждого элемента коллекции. Элементы в коллекции будут заменены значениями, возвращаемыми обратным вызовом:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3, 4, 5]);

$collection->transform(function (int $item, int $key) {
	return $item * 2;
});

$collection->all();

// [2, 4, 6, 8, 10]
								</code>
							</pre>
							<div class="alert bg-warning text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-warning-circle"></i></span>
								<span class="fw-semibold">Предупреждение!</span> В отличие от большинства других методов сбора, `transform()` модифицирует саму коллекцию.
								Если вы хотите вместо этого создать новую коллекцию, используйте <a href="#method-map" class="alert-link text-reset">map()</a> метод.
							</div>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-undot">undot()</h6>
							<p>Метод <code>undot()</code> расширяет одномерную коллекцию, использующую «точечную» нотацию, в многомерную коллекцию:</p>
							<pre class="language-php mb-2">
								<code>
$person = collect([
	'name.first_name'   => 'Marie',
	'name.last_name'    => 'Valentine',
	'address.line_1'    => '2992 Eagle Drive',
	'address.line_2'    => '',
	'address.suburb'    => 'Detroit',
	'address.state'     => 'MI',
	'address.postcode'  => '48219'
]);

$person = $person->undot();

$person->toArray();

/*
[
	"name" => [
		"first_name"    => "Marie",
		"last_name"     => "Valentine",
	],
	"address" => [
		"line_1"    => "2992 Eagle Drive",
		"line_2"    => "",
		"suburb"    => "Detroit",
		"state"     => "MI",
		"postcode"  => "48219",
	],
]
*/
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-union">union()</h6>
							<p>Метод <code>union()</code> добавляет заданный массив в коллекцию. Если данный массив содержит ключи, которые уже есть в исходной коллекции, предпочтительными будут значения исходной коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1 => ['a'], 2 => ['b']]);

$union = $collection->union([3 => ['c'], 1 => ['d']]);

$union->all();

// [1 => ['a'], 2 => ['b'], 3 => ['c']]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-unique">unique()</h6>
							<p>Метод <code>unique()</code> возвращает все уникальные элементы коллекции. Возвращаемая
								коллекция сохраняет исходные ключи массива, поэтому в следующем примере мы будем
								использовать <a href="#method-values">values()</a> метод для сброса ключей к
								последовательно пронумерованным индексам:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 1, 2, 2, 3, 4, 2]);

$unique = $collection->unique();

$unique->values()->all();

// [1, 2, 3, 4]
								</code>
							</pre>
							<p class="mb-2">При работе с вложенными массивами или объектами вы можете указать ключ, используемый для определения уникальности:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'iPhone 6', 'brand' => 'Apple', 'type' => 'phone'],
	['name' => 'iPhone 5', 'brand' => 'Apple', 'type' => 'phone'],
	['name' => 'Apple Watch', 'brand' => 'Apple', 'type' => 'watch'],
	['name' => 'Galaxy S6', 'brand' => 'Samsung', 'type' => 'phone'],
	['name' => 'Galaxy Gear', 'brand' => 'Samsung', 'type' => 'watch'],
]);

$unique = $collection->unique('brand');

$unique->values()->all();

/*
[
	['name' => 'iPhone 6', 'brand' => 'Apple', 'type' => 'phone'],
	['name' => 'Galaxy S6', 'brand' => 'Samsung', 'type' => 'phone'],
]
*/
								</code>
							</pre>
							<p class="mb-2">Наконец, вы также можете передать собственное замыкание в <code>unique()</code> метод, чтобы указать, какое значение должно определять уникальность элемента:</p>
							<pre class="language-php mb-2">
								<code>
$unique = $collection->unique(function (array $item) {
	return $item['brand'].$item['type'];
});

$unique->values()->all();

/*
[
	['name' => 'iPhone 6', 'brand' => 'Apple', 'type' => 'phone'],
	['name' => 'Apple Watch', 'brand' => 'Apple', 'type' => 'watch'],
	['name' => 'Galaxy S6', 'brand' => 'Samsung', 'type' => 'phone'],
	['name' => 'Galaxy Gear', 'brand' => 'Samsung', 'type' => 'watch'],
]
*/
								</code>
							</pre>
							<p class="mb-2">Метод <code>unique()</code> использует «свободные» сравнения при проверке значений элементов, то есть строка с целочисленным значением будет считаться равной целому числу с тем же значением.
								Используйте <a href="#method-uniqueStrict">uniqueStrict()</a> метод для фильтрации с использованием «строгих» сравнений.</p>
							<div class="alert bg-info text-white alert-icon-start alert-dismissible fade show border-0">
								<span class="alert-icon bg-black bg-opacity-20"><i class="ph-info"></i></span>
								<span class="fw-semibold">Примечание!</span> Поведение этого метода изменяется при использовании <a href="#method-unique" class="alert-link text-reset">Collections</a>.
							</div>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-uniqueStrict">uniqueStrict()</h6>
							<p>Этот метод имеет ту же сигнатуру, что и <a href="#method-unique">unique()</a> метод; однако все значения сравниваются с использованием «строгих» сравнений.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-unless">unless()</h6>
							<p>Метод <code>unless()</code> выполнит данный обратный вызов, если только первый аргумент, переданный методу, не будет равен <kbd>true</kbd>:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3]);

$collection->unless(true, function (Collection $collection) {
	return $collection->push(4);
});

$collection->unless(false, function (Collection $collection) {
	return $collection->push(5);
});

$collection->all();

// [1, 2, 3, 5]
								</code>
							</pre>
							<p class="mb-2">В метод может быть передан второй обратный вызов <code>unless()</code>.
								Второй обратный вызов будет выполнен, когда первый аргумент, переданный методу, будет <code>unless()</code> равен <kbd>true</kbd>:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3]);

$collection->unless(true, function (Collection $collection) {
	return $collection->push(4);
}, function (Collection $collection) {
	return $collection->push(5);
});

$collection->all();

// [1, 2, 3, 5]
								</code>
							</pre>
							<p class="mb-2">Для обратного <code>unless()</code> см. <a href="#method-when">when()</a> метод.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-unlessEmpty">unlessEmpty()</h6>
							<p>Псевдоним метода <a href="#method-whenNotEmpty">whenNotEmpty()</a>.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-unlessNotEmpty">unlessNotEmpty()</h6>
							<p>Псевдоним метода <a href="#method-whenEmpty">whenEmpty()</a>.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-unwrap">unwrap()</h6>
							<p>Статический <code>unwrap()</code> метод возвращает базовые элементы коллекции из заданного значения, когда это применимо:</p>
							<pre class="language-php mb-2">
								<code>
Collection::unwrap(collect('John Doe'));

// ['John Doe']

Collection::unwrap(['John Doe']);

// ['John Doe']

Collection::unwrap('John Doe');

// 'John Doe'
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-value">value()</h6>
							<p>Метод <code>value()</code> извлекает заданное значение из первого элемента коллекции:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product' => 'Desk', 'price' => 200],
	['product' => 'Speaker', 'price' => 400],
]);

$value = $collection->value('price');

// 200
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-values">values()</h6>
							<p>Метод <code>values()</code> возвращает новую коллекцию с ключами, сброшенными на последовательные целые числа:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	10 => ['product' => 'Desk', 'price' => 200],
	11 => ['product' => 'Desk', 'price' => 200],
]);

$values = $collection->values();

$values->all();

/*
[
	0 => ['product' => 'Desk', 'price' => 200],
	1 => ['product' => 'Desk', 'price' => 200],
]
*/
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-when">when()</h6>
							<p>Метод <code>when()</code> выполнит данный обратный вызов, когда первый аргумент, переданный методу, будет равен <kbd>true</kbd>.
								Экземпляр коллекции и первый аргумент, переданный методу, <code>when()</code> будут переданы замыканию:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3]);

$collection->when(true, function (Collection $collection, int $value) {
	return $collection->push(4);
});

$collection->when(false, function (Collection $collection, int $value) {
	return $collection->push(5);
});

$collection->all();

// [1, 2, 3, 4]
								</code>
							</pre>
							<p class="mb-2">В метод может быть передан второй обратный вызов <code>when()</code>. Второй обратный вызов будет выполнен, когда первый аргумент, переданный методу, будет <code>when()</code> равен <kbd>false</kbd>:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([1, 2, 3]);

$collection->when(false, function (Collection $collection, int $value) {
	return $collection->push(4);
}, function (Collection $collection) {
	return $collection->push(5);
});

$collection->all();

// [1, 2, 3, 5]
								</code>
							</pre>
							<p class="mb-2">Для обратного <code>when()</code> см. <a href="#method-unless">unless()</a> метод.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whenEmpty">whenEmpty()</h6>
							<p>Метод <code>whenEmpty()</code> выполнит данный обратный вызов, когда коллекция пуста:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['Michael', 'Tom']);

$collection->whenEmpty(function (Collection $collection) {
	return $collection->push('Adam');
});

$collection->all();

// ['Michael', 'Tom']

$collection = collect();

$collection->whenEmpty(function (Collection $collection) {
	return $collection->push('Adam');
});

$collection->all();

// ['Adam']
								</code>
							</pre>
							<p class="mb-2">Второе замыкание может быть передано в <code>whenEmpty()</code> метод, который будет выполняться, когда коллекция не пуста:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['Michael', 'Tom']);

$collection->whenEmpty(function (Collection $collection) {
	return $collection->push('Adam');
}, function (Collection $collection) {
	return $collection->push('Taylor');
});

$collection->all();

// ['Michael', 'Tom', 'Taylor']
								</code>
							</pre>
							<p class="mb-2">Для обратного <kbd>whenEmpty</kbd> см. <a href="#method-whenNotEmpty">whenNotEmpty()</a>.
							</p>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whenNotEmpty">whenNotEmpty()</h6>
							<p>Метод <code>whenNotEmpty()</code> выполнит данный обратный вызов, когда коллекция не пуста:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['michael', 'tom']);

$collection->whenNotEmpty(function (Collection $collection) {
	return $collection->push('adam');
});

$collection->all();

// ['michael', 'tom', 'adam']

$collection = collect();

$collection->whenNotEmpty(function (Collection $collection) {
	return $collection->push('adam');
});

$collection->all();

// []
								</code>
							</pre>
							<p class="mb-2">Второе замыкание может быть передано в <code>whenNotEmpty()</code> метод, который будет выполняться, когда коллекция пуста:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect();

$collection->whenNotEmpty(function (Collection $collection) {
	return $collection->push('adam');
}, function (Collection $collection) {
	return $collection->push('taylor');
});

$collection->all();

// ['taylor']
								</code>
							</pre>
							<p class="mb-2">Для обратного <code>whenNotEmpty()</code> см. <a href="#method-whenEmpty">whenEmpty()</a> метод.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-where">where()</h6>
							<p>Метод <code>where()</code> фильтрует коллекцию по заданной паре ключ/значение:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product' => 'Desk', 'price' => 200],
	['product' => 'Chair', 'price' => 100],
	['product' => 'Bookcase', 'price' => 150],
	['product' => 'Door', 'price' => 100],
]);

$filtered = $collection->where('price', 100);

$filtered->all();

/*
[
	['product' => 'Chair', 'price' => 100],
	['product' => 'Door', 'price' => 100],
]
*/
								</code>
							</pre>
							<p class="mb-2">Метод <code>where()</code> использует «свободные» сравнения при проверке значений элементов, то есть строка с целочисленным значением будет считаться равной целому числу с тем же значением.
								Используйте <a href="#method-whereStrict">whereStrict()</a> метод для фильтрации с использованием «строгих» сравнений.</p>
							<p class="mb-2">При желании вы можете передать оператор сравнения в качестве второго параметра. Поддерживаются следующие операторы: '===', '!==', '!=', '==', '=', '<>', '>', '<', '>=', и '<=':</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'Jim', 'deleted_at' => '2019-01-01 00:00:00'],
	['name' => 'Sally', 'deleted_at' => '2019-01-02 00:00:00'],
	['name' => 'Sue', 'deleted_at' => null],
]);

$filtered = $collection->where('deleted_at', '!=', null);

$filtered->all();

/*
[
	['name' => 'Jim', 'deleted_at' => '2019-01-01 00:00:00'],
	['name' => 'Sally', 'deleted_at' => '2019-01-02 00:00:00'],
]
*/
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereStrict">whereStrict()</h6>
							<p>Этот метод имеет ту же сигнатуру, что и <a href="#method-where">where()</a> метод; однако все значения сравниваются с использованием «строгих» сравнений.</p>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereBetween">whereBetween()</h6>
							<p>Метод <code>whereBetween()</code> фильтрует коллекцию, определяя, находится ли указанное значение элемента в заданном диапазоне:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product' => 'Desk', 'price' => 200],
	['product' => 'Chair', 'price' => 80],
	['product' => 'Bookcase', 'price' => 150],
	['product' => 'Pencil', 'price' => 30],
	['product' => 'Door', 'price' => 100],
]);

$filtered = $collection->whereBetween('price', [100, 200]);

$filtered->all();

/*
[
	['product' => 'Desk', 'price' => 200],
	['product' => 'Bookcase', 'price' => 150],
	['product' => 'Door', 'price' => 100],
]
*/
								</code>
							</pre>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereIn">whereIn()</h6>
							<p>Метод <code>whereIn()</code> удаляет элементы из коллекции, у которых нет указанного значения элемента, содержащегося в данном массиве:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product' => 'Desk', 'price' => 200],
	['product' => 'Chair', 'price' => 100],
	['product' => 'Bookcase', 'price' => 150],
	['product' => 'Door', 'price' => 100],
]);

$filtered = $collection->whereIn('price', [150, 200]);

$filtered->all();

/*
[
	['product' => 'Desk', 'price' => 200],
	['product' => 'Bookcase', 'price' => 150],
]
*/
								</code>
							</pre>
							<p class="mb-2">Метод <kbd>whereIn()</kbd> использует «свободные» сравнения при проверке значений элементов, то есть строка с целочисленным значением будет считаться равной целому числу с тем же значением.
								Используйте <a href="#method-whereInStrict">whereInStrict()</a> метод для фильтрации с использованием «строгих» сравнений.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereInStrict">whereInStrict()</h6>
							<p>Этот метод имеет ту же сигнатуру, что и <a href="#method-whereIn">whereIn()</a> метод; однако все значения сравниваются с использованием «строгих» сравнений. </p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereInstanceOf">whereInstanceOf()</h6>
							<p>Метод <code>whereInstanceOf()</code> фильтрует коллекцию по заданному типу класса:</p>
							<pre class="language-php mb-2">
								<code>
use App\Models\User;
use App\Models\Post;

$collection = collect([
	new User,
	new User,
	new Post,
]);

$filtered = $collection->whereInstanceOf(User::class);

$filtered->all();

// [App\Models\User, App\Models\User]
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereNotBetween">whereNotBetween()</h6>
							<p>Метод <code>whereNotBetween()</code> фильтрует коллекцию, определяя, находится ли указанное значение элемента за пределами заданного диапазона:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product' => 'Desk', 'price' => 200],
	['product' => 'Chair', 'price' => 80],
	['product' => 'Bookcase', 'price' => 150],
	['product' => 'Pencil', 'price' => 30],
	['product' => 'Door', 'price' => 100],
]);

$filtered = $collection->whereNotBetween('price', [100, 200]);

$filtered->all();

/*
[
	['product' => 'Chair', 'price' => 80],
	['product' => 'Pencil', 'price' => 30],
]
*/
								</code>
							</pre>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereNotIn">whereNotIn()</h6>
							<p>Метод <code>whereNotIn()</code> удаляет элементы из коллекции, которые имеют указанное значение элемента, содержащееся в данном массиве:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['product' => 'Desk', 'price' => 200],
    ['product' => 'Chair', 'price' => 100],
    ['product' => 'Bookcase', 'price' => 150],
    ['product' => 'Door', 'price' => 100],
]);

$filtered = $collection->whereNotIn('price', [150, 200]);

$filtered->all();

/*
[
	['product' => 'Chair', 'price' => 100],
	['product' => 'Door', 'price' => 100],
]
*/
								</code>
							</pre>
							<p class="mb-2">Метод <code>whereNotIn()</code> использует «свободные» сравнения при проверке значений элементов, то есть строка с целочисленным значением будет считаться равной целому числу с тем же значением.
								Используйте <a href="#method-whereNotInStrict">whereNotInStrict()</a> метод для фильтрации с использованием «строгих» сравнений.</p>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereNotInStrict">whereNotInStrict()</h6>
							<p>Этот метод имеет ту же сигнатуру, что и <a href="#method-whereNotIn">whereNotIn()</a>метод; однако все значения сравниваются с использованием «строгих» сравнений.</p>
						</div>
						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereNotNull">whereNotNull()</h6>
							<p>Метод <code>whereNotNull()</code> возвращает элементы из коллекции, где данный ключ не является <kbd>null</kbd>:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'Desk'],
	['name' => null],
	['name' => 'Bookcase'],
]);

$filtered = $collection->whereNotNull('name');

$filtered->all();

/*
[
	['name' => 'Desk'],
	['name' => 'Bookcase'],
]
*/
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-whereNull">whereNull()</h6>
							<p>Метод <code>whereNull()</code> возвращает элементы из коллекции, где задан данный ключ <kbd>null</kbd>:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect([
	['name' => 'Desk'],
	['name' => null],
	['name' => 'Bookcase'],
]);

$filtered = $collection->whereNull('name');

$filtered->all();

/*
[
	['name' => null],
]
*/
								</code>
							</pre>
						</div>


						<div class="mb-3">
							<h6 class="fw-semibold" id="method-wrap">wrap()</h6>
							<p>Метод <code>wrap()</code> метод оборачивает заданное значение в коллекцию, когда это применимо:</p>
							<pre class="language-php mb-2">
								<code>
use Mnv\Core\Collections\Collection;

$collection = Collection::wrap('John Doe');

$collection->all();

// ['John Doe']

$collection = Collection::wrap(['John Doe']);

$collection->all();

// ['John Doe']

$collection = Collection::wrap(collect('John Doe'));

$collection->all();

// ['John Doe']
								</code>
							</pre>
						</div>

						<div class="mb-3">
							<h6 class="fw-semibold" id="method-zip">zip()</h6>
							<p>Метод <code>zip()</code> объединяет значения данного массива со значениями исходной коллекции по их соответствующему индексу:</p>
							<pre class="language-php mb-2">
								<code>
$collection = collect(['Chair', 'Desk']);

$zipped = $collection->zip([100, 200]);

$zipped->all();

// [['Chair', 100], ['Desk', 200]]
								</code>
							</pre>
						</div>

						<div class="mb-4">
							<h6 class="fw-semibold" id="lazy-collections">Ленивые коллекции</h6>
							<div class="mb-3">
								<h6 class="fw-semibold" id="lazy-collection-introduction">Введение</h6>
								<div class="alert bg-warning text-white alert-icon-start alert-dismissible fade show border-0">
									<span class="alert-icon bg-black bg-opacity-20"><i class="ph-warning-circle"></i></span>
									<span class="fw-semibold">Предупреждение!</span> Прежде чем узнать больше о ленивых коллекциях, найдите время, чтобы ознакомиться с <a href="https://www.php.net/manual/en/language.generators.overview.php" class="alert-link text-reset" target="_blank">PHP generators</a>.
								</div>
							</div>
							<div class="mb-3">
								<p>Чтобы дополнить и без того мощный <kbd>Collection</kbd> класс, класс использует <a href="https://www.php.net/manual/en/language.generators.overview.php">generators</a> LazyCollection PHP, чтобы вы могли работать с очень большими наборами данных, сохраняя низкое использование памяти.</p>
								<p>Например, представьте, что вашему приложению необходимо обработать многогигабайтный файл журнала, используя методы сбора данных Laravel для анализа журналов.
									Вместо того, чтобы сразу считывать весь файл в память, ленивые коллекции могут использоваться для хранения в памяти только небольшой части файла в данный момент времени:</p>
								<pre class="language-php mb-2">
									<code>
use App\Models\LogEntry;
use Mnv\Core\Collections\LazyCollection;

LazyCollection::make(function () {
	$handle = fopen('log.txt', 'r');

	while (($line = fgets($handle)) !== false) {
		yield $line;
	}
})->chunk(4)->map(function (array $lines) {
	return LogEntry::fromLines($lines);
	})->each(function (LogEntry $logEntry) {
	// Process the log entry...
});
									</code>
								</pre>
								<p class="mb-2">Или представьте, что вам нужно перебрать 10 000 моделей Eloquent. При использовании традиционных коллекций все 10 000 моделей Eloquent должны быть загружены в память одновременно:</p>
								<pre class="language-php mb-2">
									<code>
use App\Models\User;

$users = User::all()->filter(function (User $user) {
	return $user->id > 500;
});
									</code>
								</pre>
								<p class="mb-2">Однако метод построителя запросов `cursor` возвращает `LazyCollection` экземпляр.
									Это позволяет вам по-прежнему выполнять только один запрос к базе данных, но при этом одновременно загружать в память только одну модель Eloquent.
									В этом примере `filter` обратный вызов не выполняется до тех пор, пока мы не обработаем каждого пользователя отдельно, что позволяет резко сократить использование памяти:</p>
								<pre class="language-php mb-2">
									<code>
use App\Models\User;

$users = User::cursor()->filter(function (User $user) {
	return $user->id > 500;
});

foreach ($users as $user) {
	echo $user->id;
}
									</code>
								</pre>
							</div>

							<div class="mb-3">
								<h6 class="fw-semibold" id="creating-lazy-collections">Создание ленивых коллекций</h6>
								<p>Чтобы создать ленивый экземпляр коллекции, вы должны передать функцию генератора PHP методу коллекции <code>make()</code>:</p>
								<pre class="language-php mb-2">
									<code>
use Mnv\Core\Collections\LazyCollection;

LazyCollection::make(function () {
	$handle = fopen('log.txt', 'r');

	while (($line = fgets($handle)) !== false) {
		yield $line;
	}
});
									</code>
								</pre>
							</div>


							<div class="mb-3">
								<h6 class="fw-semibold" id="the-enumerable-contract">Перечислимый контракт</h6>
								<p class="mb-2">Почти все методы, доступные в <kbd>Collection</kbd> классе, также
									доступны в <kbd>LazyCollection</kbd> классе. Оба этих класса реализуют <kbd>Enumerable</kbd>
									контракт, который определяет следующие методы:</p>
								<ul class="list-inline mb-0">
									<li class="list-inline-item"><a href="#method-all">all</a></li>
									<li class="list-inline-item"><a href="#method-average">average</a></li>
									<li class="list-inline-item"><a href="#method-avg">avg</a></li>
									<li class="list-inline-item"><a href="#method-chunk">chunk</a></li>
									<li class="list-inline-item"><a href="#method-chunkWhile">chunkWhile</a></li>
									<li class="list-inline-item"><a href="#method-collapse">collapse</a></li>
									<li class="list-inline-item"><a href="#method-collect">collect</a></li>
									<li class="list-inline-item"><a href="#method-combine">combine</a></li>
									<li class="list-inline-item"><a href="#method-concat">concat</a></li>
									<li class="list-inline-item"><a href="#method-contains">contains</a></li>
									<li class="list-inline-item"><a href="#method-containsStrict">containsStrict</a></li>
									<li class="list-inline-item"><a href="#method-countBy">countBy</a></li>
									<li class="list-inline-item"><a href="#method-crossJoin">crossJoin</a></li>
									<li class="list-inline-item"><a href="#method-diff">diff</a></li>
									<li class="list-inline-item"><a href="#method-diffAssoc">diffAssoc</a></li>
									<li class="list-inline-item"><a href="#method-diffKeys">diffKeys</a></li>
									<li class="list-inline-item"><a href="#method-duplicates">duplicates</a></li>
									<li class="list-inline-item"><a href="#method-duplicatesStrict">duplicatesStrict</a></li>
									<li class="list-inline-item"><a href="#method-each">each</a></li>
									<li class="list-inline-item"><a href="#method-eachSpread">eachSpread</a></li>
									<li class="list-inline-item"><a href="#method-every">every</a></li>
									<li class="list-inline-item"><a href="#method-except">except</a></li>
									<li class="list-inline-item"><a href="#method-filter">filter</a></li>
									<li class="list-inline-item"><a href="#method-first">first</a></li>
									<li class="list-inline-item"><a href="#method-firstOrFail">firstOrFail</a></li>
									<li class="list-inline-item"><a href="#method-firstWhere">firstWhere</a></li>
									<li class="list-inline-item"><a href="#method-flatMap">flatMap</a></li>
									<li class="list-inline-item"><a href="#method-flip">flip</a></li>
									<li class="list-inline-item"><a href="#method-forPage">forPage</a></li>
									<li class="list-inline-item"><a href="#method-get">get</a></li>
									<li class="list-inline-item"><a href="#method-groupBy">groupBy</a></li>
									<li class="list-inline-item"><a href="#method-has">has</a></li>
									<li class="list-inline-item"><a href="#method-implode">implode</a></li>
									<li class="list-inline-item"><a href="#method-intersect">intersect</a></li>
									<li class="list-inline-item"><a href="#method-intersectAssoc">intersectAssoc</a></li>
									<li class="list-inline-item"><a href="#method-intersectByKeys">intersectByKeys</a></li>
									<li class="list-inline-item"><a href="#method-isEmpty">isEmpty</a></li>
									<li class="list-inline-item"><a href="#method-isNotEmpty">isNotEmpty</a></li>
									<li class="list-inline-item"><a href="#method-join">join</a></li>
									<li class="list-inline-item"><a href="#method-keyBy">keyBy</a></li>
									<li class="list-inline-item"><a href="#method-keys">keys</a></li>
									<li class="list-inline-item"><a href="#method-last">last</a></li>
									<li class="list-inline-item"><a href="#method-macro">macro</a></li>
									<li class="list-inline-item"><a href="#method-make">make</a></li>
									<li class="list-inline-item"><a href="#method-map">map</a></li>
									<li class="list-inline-item"><a href="#method-make">make</a></li>
									<li class="list-inline-item"><a href="#method-mapInto">mapInto</a></li>
									<li class="list-inline-item"><a href="#method-mapSpread">mapSpread</a></li>
									<li class="list-inline-item"><a href="#method-mapToGroups">mapToGroups</a></li>
									<li class="list-inline-item"><a href="#method-mapWithKeys">mapWithKeys</a></li>
									<li class="list-inline-item"><a href="#method-max">max</a></li>
									<li class="list-inline-item"><a href="#method-median">median</a></li>
									<li class="list-inline-item"><a href="#method-merge">merge</a></li>
									<li class="list-inline-item"><a href="#method-mergeRecursive">mergeRecursive</a></li>
									<li class="list-inline-item"><a href="#method-min">min</a></li>
									<li class="list-inline-item"><a href="#method-mode">mode</a></li>
									<li class="list-inline-item"><a href="#method-only">only</a></li>
									<li class="list-inline-item"><a href="#method-pad">pad</a></li>
									<li class="list-inline-item"><a href="#method-partition">partition</a></li>
									<li class="list-inline-item"><a href="#method-pipe">pipe</a></li>
									<li class="list-inline-item"><a href="#method-pluck">pluck</a></li>
									<li class="list-inline-item"><a href="#method-random">random</a></li>
									<li class="list-inline-item"><a href="#method-reduce">reduce</a></li>
									<li class="list-inline-item"><a href="#method-reject">reject</a></li>
									<li class="list-inline-item"><a href="#method-replace">replace</a></li>
									<li class="list-inline-item"><a href="#method-replaceRecursive">replaceRecursive</a></li>
									<li class="list-inline-item"><a href="#method-reverse">reverse</a></li>
									<li class="list-inline-item"><a href="#method-search">search</a></li>
									<li class="list-inline-item"><a href="#method-shuffle">shuffle</a></li>
									<li class="list-inline-item"><a href="#method-skip">skip</a></li>
									<li class="list-inline-item"><a href="#method-sole">sole</a></li>
									<li class="list-inline-item"><a href="#method-some">some</a></li>
									<li class="list-inline-item"><a href="#method-sort">sort</a></li>
									<li class="list-inline-item"><a href="#method-sortBy">sortBy</a></li>
									<li class="list-inline-item"><a href="#method-sortByDesc">sortByDesc</a></li>
									<li class="list-inline-item"><a href="#method-sortKeys">sortKeys</a></li>
									<li class="list-inline-item"><a href="#method-sortKeysDesc">sortKeysDesc</a></li>
									<li class="list-inline-item"><a href="#method-split">split</a></li>
									<li class="list-inline-item"><a href="#method-sum">sum</a></li>
									<li class="list-inline-item"><a href="#method-take">take</a></li>
									<li class="list-inline-item"><a href="#method-tap">tap</a></li>
									<li class="list-inline-item"><a href="#method-times">times</a></li>
									<li class="list-inline-item"><a href="#method-toArray">toArray</a></li>
									<li class="list-inline-item"><a href="#method-toJson">toJson</a></li>
									<li class="list-inline-item"><a href="#method-union">union</a></li>
									<li class="list-inline-item"><a href="#method-unique">unique</a></li>
									<li class="list-inline-item"><a href="#method-uniqueStrict">uniqueStrict</a></li>
									<li class="list-inline-item"><a href="#method-unless">unless</a></li>
									<li class="list-inline-item"><a href="#method-unlessEmpty">unlessEmpty</a></li>
									<li class="list-inline-item"><a href="#method-unlessNotEmpty">unlessNotEmpty</a></li>
									<li class="list-inline-item"><a href="#method-unwrap">unwrap</a></li>
									<li class="list-inline-item"><a href="#method-values">values</a></li>
									<li class="list-inline-item"><a href="#method-when">when</a></li>
									<li class="list-inline-item"><a href="#method-whenEmpty">whenEmpty</a></li>
									<li class="list-inline-item"><a href="#method-whenNotEmpty">whenNotEmpty</a></li>
									<li class="list-inline-item"><a href="#method-whereStrict">whereStrict</a></li>
									<li class="list-inline-item"><a href="#method-whereBetween">whereBetween</a></li>
									<li class="list-inline-item"><a href="#method-whereIn">whereIn</a></li>
									<li class="list-inline-item"><a href="#method-whereInStrict">whereInStrict</a></li>
									<li class="list-inline-item"><a href="#method-whereInstanceOf">whereInstanceOf</a></li>
									<li class="list-inline-item"><a href="#method-whereNotBetween">whereNotBetween</a></li>
									<li class="list-inline-item"><a href="#method-whereNotIn">whereNotIn</a></li>
									<li class="list-inline-item"><a href="#method-whereNotInStrict">whereNotInStrict</a></li>
									<li class="list-inline-item"><a href="#method-wrap">wrap</a></li>
									<li class="list-inline-item"><a href="#method-zip">zip</a></li>
								</ul>
							</div>

						</div>

					</div>
				</div>
			</div>

			<div class="sticky-lg-top order-1 order-lg-2 wmin-lg-300 ms-lg-3 mb-3" id="page_nav">
				<h6 class="fw-semibold mt-lg-3 mb-3">Коллекция</h6>

				<ul class="nav nav-scrollspy flex-column">
					<li class="nav-item"><a href="#introduction" class="nav-link">Введение</a></li>
					<li class="nav-item">
						<a href="#available-methods" class="nav-link">Доступные методы</a>
						<ul class="nav nav-scrollspy flex-column">
							<li class="nav-item"><a href="#method-all" class="nav-link">all</a></li>
							<li class="nav-item"><a href="#method-collapse" class="nav-link">collapse</a></li>
							<li class="nav-item"><a href="#method-combine" class="nav-link">combine</a></li>
							<li class="nav-item"><a href="#method-concat" class="nav-link">concat</a></li>
							<li class="nav-item"><a href="#method-count" class="nav-link">count</a></li>
							<li class="nav-item"><a href="#method-crossJoin" class="nav-link">crossJoin</a></li>
							<li class="nav-item"><a href="#method-every" class="nav-link">every</a></li>
							<li class="nav-item"><a href="#method-filter" class="nav-link">filter</a></li>
							<li class="nav-item"><a href="#method-first" class="nav-link">first</a></li>
							<li class="nav-item"><a href="#method-forget" class="nav-link">forget</a></li>
							<li class="nav-item"><a href="#method-forPage" class="nav-link">forPage</a></li>
							<li class="nav-item"><a href="#method-get" class="nav-link">get</a></li>
							<li class="nav-item"><a href="#method-groupBy" class="nav-link">groupBy</a></li>
							<li class="nav-item"><a href="#method-has" class="nav-link">has</a></li>
							<li class="nav-item"><a href="#method-implode" class="nav-link">implode</a></li>
							<li class="nav-item"><a href="#method-intersect" class="nav-link">intersect</a></li>
							<li class="nav-item"><a href="#method-isEmpty" class="nav-link">isEmpty</a></li>
							<li class="nav-item"><a href="#method-join" class="nav-link">join</a></li>
							<li class="nav-item"><a href="#method-keyBy" class="nav-link">keyBy</a></li>
							<li class="nav-item"><a href="#method-keys" class="nav-link">keys</a></li>
							<li class="nav-item"><a href="#method-last" class="nav-link">last</a></li>
							<li class="nav-item"><a href="#method-lazy" class="nav-link">lazy</a></li>
							<li class="nav-item"><a href="#method-make" class="nav-link">make</a></li>
							<li class="nav-item"><a href="#method-map" class="nav-link">map</a></li>
							<li class="nav-item"><a href="#method-max" class="nav-link">max</a></li>
							<li class="nav-item"><a href="#method-median" class="nav-link">median</a></li>
							<li class="nav-item"><a href="#method-merge" class="nav-link">merge</a></li>
							<li class="nav-item"><a href="#method-mode" class="nav-link">mode</a></li>
							<li class="nav-item"><a href="#method-only" class="nav-link">only</a></li>
							<li class="nav-item"><a href="#method-pad" class="nav-link">pad</a></li>
							<li class="nav-item"><a href="#method-pipe" class="nav-link">pipe</a></li>
							<li class="nav-item"><a href="#method-pluck" class="nav-link">pluck</a></li>
							<li class="nav-item"><a href="#method-pop" class="nav-link">pop</a></li>
							<li class="nav-item"><a href="#method-prepend" class="nav-link">prepend</a></li>
							<li class="nav-item"><a href="#method-pull" class="nav-link">pull</a></li>
							<li class="nav-item"><a href="#method-push" class="nav-link">push</a></li>
							<li class="nav-item"><a href="#method-put" class="nav-link">put</a></li>
							<li class="nav-item"><a href="#method-random" class="nav-link">random</a></li>
							<li class="nav-item"><a href="#method-replace" class="nav-link">replace</a></li>
							<li class="nav-item"><a href="#method-reverse" class="nav-link">reverse</a></li>
							<li class="nav-item"><a href="#method-search" class="nav-link">search</a></li>
							<li class="nav-item"><a href="#method-shift" class="nav-link">shift</a></li>
							<li class="nav-item"><a href="#method-skip" class="nav-link">skip</a></li>
							<li class="nav-item"><a href="#method-sort" class="nav-link">sort</a></li>
							<li class="nav-item"><a href="#method-splice" class="nav-link">splice</a></li>
							<li class="nav-item"><a href="#method-split" class="nav-link">split</a></li>
							<li class="nav-item"><a href="#method-sum" class="nav-link">sum</a></li>
							<li class="nav-item"><a href="#method-times" class="nav-link">times</a></li>
							<li class="nav-item"><a href="#method-toArray" class="nav-link">toArray</a></li>
							<li class="nav-item"><a href="#method-toJson" class="nav-link">toJson</a></li>
							<li class="nav-item"><a href="#method-unique" class="nav-link">unique</a></li>
							<li class="nav-item"><a href="#method-unwrap" class="nav-link">unwrap</a></li>
							<li class="nav-item"><a href="#method-value" class="nav-link">value</a></li>
							<li class="nav-item"><a href="#method-when" class="nav-link">when</a></li>
							<li class="nav-item"><a href="#method-where" class="nav-link">where</a></li>
							<li class="nav-item"><a href="#method-wrap" class="nav-link">wrap</a></li>
							<li class="nav-item"><a href="#method-zip" class="nav-link">zip</a></li>
						</ul>
					</li>
					<li class="nav-item">
						<a href="#lazy-collections" class="nav-link">Ленивые коллекции</a>
						<ul class="nav nav-scrollspy flex-column">
							<li class="nav-item"><a href="#creating-lazy-collections" class="nav-link">Создание ленивых коллекций</a></li>
							<li class="nav-item"><a href="#the-enumerable-contract" class="nav-link">Перечислимый контракт</a></li>
						</ul>
					</li>
				</ul>
			</div>

		</div>

	</div>
</div><?php }
}
